"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get All FAQ Feedback",description:"Retrieves all FAQ feedback records including user ratings and comments. Returns feedback ordered by creation date.",operationId:"getAllFaqFeedback",tags:["Admin","FAQ","Feedback"],requiresAuth:!0,responses:{200:{description:"Feedback records retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",format:"uuid"},faqId:{type:"string",format:"uuid"},userId:{type:"string",format:"uuid"},isHelpful:{type:"boolean"},comment:{type:"string",nullable:!0},createdAt:{type:"string",format:"date-time"},updatedAt:{type:"string",format:"date-time"}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.faq.feedback",logModule:"ADMIN_FAQ",logTitle:"Get all FAQ feedback"};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==t||t.step("Fetching all faq feedback");const e=await db_1.models.faqFeedback.findAll({order:[["createdAt","ASC"]]});null==t||t.success("all FAQ feedback retrieved successfully");return e}catch(e){console.error("Error fetching FAQ feedback:",e);null==t||t.fail("Failed to fetch all faq feedback");throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to fetch feedback"})}};