"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get FAQ Categories",description:"Retrieves a list of distinct FAQ categories. Returns all unique category names from the FAQ database.",operationId:"getFaqCategories",tags:["Admin","FAQ","Categories"],requiresAuth:!0,responses:{200:{description:"Categories retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"string",description:"Category name"}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.faq.category",logModule:"ADMIN_FAQ",logTitle:"Get FAQ categories"};exports.default=async e=>{const{user:r,ctx:s}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==s||s.step("Fetching FAQ categories");const t=(await db_1.models.faq.findAll({attributes:[[(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.col)("category")),"category"]],raw:!0})).map(e=>e.category);null==s||s.success("FAQ categories retrieved successfully");return t};