"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const deepseek_client_1=require("@b/utils/ai/deepseek-client"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Suggest Tags for FAQ with AI",description:"Uses AI to analyze an FAQ question and answer pair to suggest 3-5 relevant tags. Tags help with categorization and searchability of FAQ content.",operationId:"suggestFaqTagsWithAi",tags:["Admin","FAQ","AI"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{question:{type:"string",description:"The FAQ question"},answer:{type:"string",description:"The FAQ answer"}},required:["question","answer"]}}}},responses:{200:{description:"Tags suggested successfully",content:{"application/json":{schema:{type:"object",properties:{tags:{type:"array",items:{type:"string"},description:"AI-suggested tags (3-5 tags)"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"create.faq",logModule:"ADMIN_FAQ",logTitle:"AI suggest tags"};exports.default=async e=>{const{user:s,body:t,ctx:r}=e;if(!(null==s?void 0:s.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{question:i,answer:o}=t;if(!i||!o){null==r||r.fail("Missing required fields");throw(0,error_1.createError)({statusCode:400,message:"Missing required fields"})}try{null==r||r.step("Suggesting tags with AI");const e=await deepseek_client_1.deepseekClient.suggestTags(i,o);null==r||r.success("Tags suggested successfully");return e}catch(e){null==r||r.fail("Failed to suggest tags");throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to suggest tags"})}};