"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const deepseek_client_1=require("@b/utils/ai/deepseek-client"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Improve FAQ Answer with AI",description:"Uses AI to enhance an existing FAQ answer, making it more comprehensive, clear, and helpful. The improved answer maintains the original intent while improving readability and completeness.",operationId:"improveFaqAnswerWithAi",tags:["Admin","FAQ","AI"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{question:{type:"string",description:"The FAQ question"},answer:{type:"string",description:"Current answer to be improved"}},required:["question","answer"]}}}},responses:{200:{description:"FAQ answer improved successfully",content:{"application/json":{schema:{type:"object",properties:{answer:{type:"string",description:"AI-improved answer"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"create.faq",logModule:"ADMIN_FAQ",logTitle:"AI improve FAQ"};exports.default=async e=>{const{user:r,body:s,ctx:i}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{question:t,answer:o}=s;if(!t||!o){null==i||i.fail("Missing required fields");throw(0,error_1.createError)({statusCode:400,message:"Missing required fields"})}try{null==i||i.step("Improving FAQ with AI");const e=await deepseek_client_1.deepseekClient.improveFAQ(t,o);null==i||i.success("FAQ improved successfully");return e}catch(e){null==i||i.fail("Failed to improve FAQ");throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to improve FAQ"})}};