"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const deepseek_client_1=require("@b/utils/ai/deepseek-client"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Generate FAQ Content with AI",description:"Generates a comprehensive FAQ question and answer pair based on a given topic and optional context using AI. Returns structured FAQ content ready to be saved.",operationId:"generateFaqWithAi",tags:["Admin","FAQ","AI"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{topic:{type:"string",description:"Topic for the FAQ"},context:{type:"string",description:"Optional additional context for FAQ generation"}},required:["topic"]}}}},responses:{200:{description:"FAQ content generated successfully",content:{"application/json":{schema:{type:"object",properties:{question:{type:"string",description:"Generated FAQ question"},answer:{type:"string",description:"Generated FAQ answer"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"create.faq",logModule:"ADMIN_FAQ",logTitle:"AI generate FAQ"};exports.default=async e=>{const{user:r,body:t,ctx:s}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{topic:o,context:n}=t;if(!o){null==s||s.fail("Topic is required");throw(0,error_1.createError)({statusCode:400,message:"Topic is required"})}try{null==s||s.step("Generating FAQ with AI");const e=await deepseek_client_1.deepseekClient.generateFAQ(o,n);null==s||s.success("FAQ generated successfully");return e}catch(e){null==s||s.fail("Failed to generate FAQ");throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to generate FAQ"})}};