"use strict";async function getAllMasterWallets(e){var t,a;null===(t=null==e?void 0:e.step)||void 0===t||t.call(e,"Fetching all master wallets");const s=await db_1.models.ecosystemMasterWallet.findAll({attributes:wallet_1.walletResponseAttributes});null===(a=null==e?void 0:e.success)||void 0===a||a.call(e,`Found ${s.length} master wallet(s)`);return s}async function getMasterWalletById(e,t){var a,s,n;null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Fetching master wallet by ID: ${e}`);const r=await db_1.models.ecosystemMasterWallet.findOne({where:{id:e},attributes:wallet_1.walletResponseAttributes});r?null===(s=null==t?void 0:t.success)||void 0===s||s.call(t,`Master wallet found: ${e}`):null===(n=null==t?void 0:t.fail)||void 0===n||n.call(t,`Master wallet not found: ${e}`);return r}async function getMasterWallet(e,t){var a,s,n;null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Fetching master wallet: ${e}`);const r=await db_1.models.ecosystemMasterWallet.findOne({where:{id:e}});r?null===(s=null==t?void 0:t.success)||void 0===s||s.call(t,`Master wallet retrieved: ${e}`):null===(n=null==t?void 0:t.fail)||void 0===n||n.call(t,`Master wallet not found: ${e}`);return r}async function createMasterWallet(e,t,a){var s,n,r;null===(s=null==a?void 0:a.step)||void 0===s||s.call(a,`Creating master wallet for ${t} on ${e.chain}`);try{const s=await db_1.models.ecosystemMasterWallet.create({currency:t,chain:e.chain,address:e.address,data:e.data,status:!0});null===(n=null==a?void 0:a.success)||void 0===n||n.call(a,`Master wallet created: ${s.id}`);return s}catch(e){null===(r=null==a?void 0:a.fail)||void 0===r||r.call(a,e.message);throw e}}async function updateMasterWalletBalance(e,t,a){var s,n,r;null===(s=null==a?void 0:a.step)||void 0===s||s.call(a,`Updating master wallet balance for ${e}: ${t}`);try{await db_1.models.ecosystemMasterWallet.update({balance:t},{where:{id:e}});null===(n=null==a?void 0:a.success)||void 0===n||n.call(a,`Master wallet balance updated: ${e}`);return getMasterWalletById(e,a)}catch(e){null===(r=null==a?void 0:a.fail)||void 0===r||r.call(a,e.message);throw e}}async function deployCustodialContract(e,t){var a,s,n;null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Deploying custodial contract for ${e.chain}`);try{const a=await(0,provider_1.getProvider)(e.chain);if(!a)throw(0,error_1.createError)({statusCode:503,message:"Provider not initialized"});let n;if(!e.data)throw(0,error_1.createError)({statusCode:500,message:"Mnemonic not found"});try{n=JSON.parse((0,encrypt_1.decrypt)(e.data))}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Failed to decrypt mnemonic: ${e.message}`})}if(!n||!n.privateKey)throw(0,error_1.createError)({statusCode:500,message:"Decrypted data or Mnemonic not found"});const{privateKey:r}=n,o=new ethers_1.ethers.Wallet(r).connect(a),{abi:l,bytecode:c}=await(0,smartContract_1.getSmartContract)("wallet","CustodialWalletERC20");if(!l||!c)throw(0,error_1.createError)({statusCode:500,message:"Smart contract ABI or Bytecode not found"});const i=new ethers_1.ContractFactory(l,c,o),d=await(0,gas_1.getAdjustedGasPrice)(a),u=await i.deploy(e.address,{gasPrice:d}),h=await u.waitForDeployment(),m=await h.getAddress();null===(s=null==t?void 0:t.success)||void 0===s||s.call(t,`Custodial contract deployed at ${m}`);return m}catch(e){null===(n=null==t?void 0:t.fail)||void 0===n||n.call(t,e.message);throw(0,error_1.createError)({statusCode:500,message:e.message})}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,a,s){void 0===s&&(s=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}});Object.defineProperty(e,s,n)}:function(e,t,a,s){void 0===s&&(s=a);e[s]=t[a]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(t[t.length]=a);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var a={};if(null!=t)for(var s=e(t),n=0;n<s.length;n++)"default"!==s[n]&&__createBinding(a,t,s[n]);__setModuleDefault(a,t);return a}}(),__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.getEcosystemMasterWalletBalance=exports.createEVMWallet=exports.createAndEncryptWallet=exports.ecosystemMasterWalletStoreSchema=exports.ecosystemMasterWalletUpdateSchema=exports.baseEcosystemMasterWalletSchema=exports.ecosystemMasterWalletSchema=void 0;exports.getAllMasterWallets=getAllMasterWallets;exports.getMasterWalletById=getMasterWalletById;exports.getMasterWallet=getMasterWallet;exports.createMasterWallet=createMasterWallet;exports.updateMasterWalletBalance=updateMasterWalletBalance;exports.deployCustodialContract=deployCustodialContract;const fs=__importStar(require("fs")),utxo_1=require("@b/api/(ext)/ecosystem/utils/utxo"),encrypt_1=require("@b/utils/encrypt"),schema_1=require("@b/utils/schema"),ethers_1=require("ethers"),redis_1=require("@b/utils/redis"),date_fns_1=require("date-fns"),gas_1=require("@b/api/(ext)/ecosystem/utils/gas"),db_1=require("@b/db"),provider_1=require("@b/api/(ext)/ecosystem/utils/provider"),chains_1=require("@b/api/(ext)/ecosystem/utils/chains"),smartContract_1=require("@b/api/(ext)/ecosystem/utils/smartContract"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),safe_imports_1=require("@b/utils/safe-imports"),path_1=__importDefault(require("path")),error_1=require("@b/utils/error"),id=(0,schema_1.baseStringSchema)("ID of the ecosystem master wallet"),chain=(0,schema_1.baseStringSchema)("Blockchain chain associated with the master wallet",255),currency=(0,schema_1.baseStringSchema)("Currency used in the master wallet",255),address=(0,schema_1.baseStringSchema)("Address of the master wallet",255),balance=(0,schema_1.baseNumberSchema)("Balance of the master wallet"),data=(0,schema_1.baseStringSchema)("Additional data associated with the master wallet",1e3,0,!0),status=(0,schema_1.baseEnumSchema)("Operational status of the master wallet",["ACTIVE","INACTIVE"]),lastIndex=(0,schema_1.baseNumberSchema)("Last index used for generating wallet address");exports.ecosystemMasterWalletSchema={id:id,chain:chain,currency:currency,address:address,balance:balance,data:data,status:status,lastIndex:lastIndex};exports.baseEcosystemMasterWalletSchema={id:id,chain:chain,currency:currency,address:address,balance:balance,data:data,status:status,lastIndex:lastIndex};exports.ecosystemMasterWalletUpdateSchema={type:"object",properties:{chain:chain,currency:currency,address:address,balance:balance,data:data,status:status,lastIndex:lastIndex},required:["chain","currency","address","status","lastIndex"]};exports.ecosystemMasterWalletStoreSchema={description:"Master wallet created or updated successfully",content:{"application/json":{schema:{type:"object",properties:exports.baseEcosystemMasterWalletSchema}}}};const createAndEncryptWallet=async(e,t)=>{var a,s;null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Creating and encrypting wallet for ${e}`);let n;if(["BTC","LTC","DOGE","DASH"].includes(e))n=(0,utxo_1.createUTXOWallet)(e);else if("SOL"===e){const e=await(0,safe_imports_1.getSolanaService)();if(!e)throw(0,error_1.createError)({statusCode:503,message:"Solana service not available"});n=(await e.getInstance()).createWallet()}else if("TRON"===e){const e=await(0,safe_imports_1.getTronService)();if(!e)throw(0,error_1.createError)({statusCode:503,message:"Tron service not available"});n=(await e.getInstance()).createWallet()}else if("XMR"===e){const e=await(0,safe_imports_1.getMoneroService)();if(!e)throw(0,error_1.createError)({statusCode:503,message:"Monero service not available"});const t=await e.getInstance();n=await t.createWallet("master_wallet")}else if("TON"===e){const e=await(0,safe_imports_1.getTonService)();if(!e)throw(0,error_1.createError)({statusCode:503,message:"TON service not available"});const t=await e.getInstance();n=await t.createWallet()}else n=(0,exports.createEVMWallet)();const r=[path_1.default.resolve(process.cwd(),"backend","ecosystem","wallets"),path_1.default.resolve(__dirname,"../../../../../ecosystem","wallets"),path_1.default.resolve(process.cwd(),"ecosystem","wallets"),path_1.default.resolve(__dirname,"../../../../ecosystem","wallets")];let o=r[0];for(const e of r){const t=path_1.default.dirname(e);if(fs.existsSync(t)){o=e;console.log(`Using wallet directory: ${o}`);break}}const l=`${o}/${e}.json`;fs.existsSync(o)||fs.mkdirSync(o,{recursive:!0});await fs.writeFileSync(l,JSON.stringify(n),"utf8");const c=(0,encrypt_1.encrypt)(JSON.stringify(n.data));null===(s=null==t?void 0:t.success)||void 0===s||s.call(t,`Wallet created and encrypted for ${e}: ${n.address}`);return{address:n.address,chain:e,data:c}};exports.createAndEncryptWallet=createAndEncryptWallet;const createEVMWallet=()=>{const e=ethers_1.ethers.Wallet.createRandom();if(!e.mnemonic)throw(0,error_1.createError)({statusCode:500,message:"Mnemonic not found"});const t=ethers_1.ethers.HDNodeWallet.fromPhrase(e.mnemonic.phrase);if(!t)throw(0,error_1.createError)({statusCode:500,message:"HDNode not found"});const a=t.extendedKey,s=t.neuter().extendedKey;if(!t.mnemonic)throw(0,error_1.createError)({statusCode:500,message:"Mnemonic not found"});const n=t.mnemonic.phrase,r=t.address,o=t.publicKey,l=t.privateKey,c=t.path;return{address:r,data:{mnemonic:n,publicKey:o,privateKey:l,xprv:a,xpub:s,chainCode:t.chainCode,path:c}}};exports.createEVMWallet=createEVMWallet;const getEcosystemMasterWalletBalance=async(e,t)=>{var a,s,n,r,o,l,c,i;null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Fetching balance for master wallet ${e.chain}: ${e.address.substring(0,10)}...`);try{const a=`wallet:${e.id}:balance`,i=redis_1.RedisSingleton.getInstance();let d,u=await i.get(a);if(u){"object"!=typeof u&&(u=JSON.parse(u));const e=new Date,t=new Date(u.timestamp);if((0,date_fns_1.differenceInMinutes)(e,t)<1)return}if(["BTC","LTC","DOGE","DASH"].includes(e.chain))d=await(0,utxo_1.fetchUTXOWalletBalance)(e.chain,e.address);else if("SOL"===e.chain){const t=await(0,safe_imports_1.getSolanaService)();if(!t){console.log(`[${e.chain}] Solana service module not loaded. Ensure the Solana extension is properly installed.`);return}try{const a=await t.getInstance();d=await a.getBalance(e.address)}catch(t){const a=t.message||"";a.includes("not active")?console.log(`[${e.chain}] Solana chain not active. Please ensure:\n  1. SOL_NETWORK is set in your .env (mainnet-beta or devnet)\n  2. SOL_MAINNET_RPC or SOL_DEVNET_RPC is configured with a valid RPC URL`):a.includes("ECONNREFUSED")||a.includes("fetch failed")?console.log(`[${e.chain}] Cannot connect to Solana RPC. Check your SOL RPC configuration.`):console.log(`[${e.chain}] Error: ${a.substring(0,150)}`);return}}else if("TRON"===e.chain){const t=await(0,safe_imports_1.getTronService)();if(!t){console.log(`[${e.chain}] Tron service module not loaded. Ensure the Tron extension is properly installed.`);return}try{const a=await t.getInstance();d=await a.getBalance(e.address)}catch(t){const a=t.message||"";a.includes("ECONNREFUSED")||a.includes("fetch failed")?console.log(`[${e.chain}] Cannot connect to Tron network. Check your TRON RPC configuration.`):console.log(`[${e.chain}] Error: ${a.substring(0,150)}`);return}}else if("XMR"===e.chain){const t=await(0,safe_imports_1.getMoneroService)();if(!t){console.log(`[${e.chain}] Monero service module not loaded. Ensure the Monero extension is properly installed.`);return}try{const e=await t.getInstance();d=await e.getBalance("master_wallet")}catch(t){(null===(s=t.message)||void 0===s?void 0:s.includes("not active"))||(null===(n=t.message)||void 0===n?void 0:n.includes("not synchronized"))?console.log(`[${e.chain}] Monero daemon not synchronized. Please ensure:\n  1. Monero daemon (monerod) is running\n  2. XMR_DAEMON_RPC_URL is set correctly (e.g., http://localhost:18081/json_rpc)\n  3. The daemon is fully synchronized with the network`):(null===(r=t.message)||void 0===r?void 0:r.includes("ECONNREFUSED"))||(null===(o=t.message)||void 0===o?void 0:o.includes("fetch failed"))?console.log(`[${e.chain}] Cannot connect to Monero daemon. Please check:\n  1. Monero daemon (monerod) is running on the configured host/port\n  2. XMR_DAEMON_RPC_URL env variable is correct\n  3. Firewall/network allows the connection`):console.log(`[${e.chain}] Error: ${null===(l=t.message)||void 0===l?void 0:l.substring(0,150)}`);return}}else if("TON"===e.chain){const t=await(0,safe_imports_1.getTonService)();if(!t){console.log(`[${e.chain}] TON service module not loaded. Ensure the TON extension is properly installed.`);return}try{const a=await t.getInstance();d=await a.getBalance(e.address)}catch(t){const a=t.message||"";a.includes("not active")?console.log(`[${e.chain}] TON chain not active. Please ensure:\n  1. TON_NETWORK is set in your .env (mainnet or testnet)\n  2. TON API configuration is correct`):a.includes("ECONNREFUSED")||a.includes("fetch failed")?console.log(`[${e.chain}] Cannot connect to TON network. Check your TON configuration.`):console.log(`[${e.chain}] Error: ${a.substring(0,150)}`);return}}else try{const t=await(0,provider_1.getProvider)(e.chain),a=await t.getBalance(e.address),s=chains_1.chainConfigs[e.chain].decimals;d=ethers_1.ethers.formatUnits(a.toString(),s)}catch(t){const a=t.message||"";if(a.includes("NETWORK is not set"))console.log(`[${e.chain}] Missing environment variable: ${e.chain}_NETWORK\n  Set it to 'mainnet' or 'testnet' in your .env file`);else if(a.includes("_RPC is not set")||a.includes("Environment variable")&&a.includes("RPC")){const t=process.env[`${e.chain}_NETWORK`]||"mainnet";console.log(`[${e.chain}] Missing RPC URL. Set ${e.chain}_${t.toUpperCase()}_RPC in your .env file\n  Example: ${e.chain}_${t.toUpperCase()}_RPC=https://your-rpc-endpoint.com`)}else a.includes("ECONNREFUSED")||a.includes("fetch failed")||a.includes("getaddrinfo")?console.log(`[${e.chain}] Cannot connect to RPC endpoint. Please check:\n  1. The RPC URL is correct and accessible\n  2. The RPC service is running\n  3. Network/firewall allows the connection`):a.includes("Unsupported chain")?console.log(`[${e.chain}] Chain not configured in chainConfigs. Add configuration for this chain.`):a.includes("Chain ID not found")?console.log(`[${e.chain}] Chain ID not configured for the selected network. Check chainConfigs.`):console.log(`[${e.chain}] Provider error: ${a.substring(0,150)}`);return}if(!d||isNaN(parseFloat(d))){console.log(`Invalid formatted balance for ${e.chain} wallet: ${d}`);return}const h=parseFloat(d);await updateMasterWalletBalance(e.id,h,t);const m={balance:d,timestamp:(new Date).toISOString()};await i.setex(a,60,JSON.stringify(m));null===(c=null==t?void 0:t.success)||void 0===c||c.call(t,`Balance updated for ${e.chain}: ${h}`)}catch(a){const s=`Failed to fetch ${e.chain} wallet balance: ${a.message}`;null===(i=null==t?void 0:t.fail)||void 0===i||i.call(t,s);console.error(s)}};exports.getEcosystemMasterWalletBalance=getEcosystemMasterWalletBalance;