"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db"),chains_1=require("@b/api/(ext)/ecosystem/utils/chains");exports.metadata={summary:"Get available blockchain options for master wallet creation",description:"Retrieves a list of supported blockchain chains that can be used to create new master wallets. Includes both static chains (ETH, BSC, POLYGON, etc.) and dynamically enabled chains from the ecosystem blockchain configuration.",operationId:"getEcosystemMasterWalletOptions",tags:["Admin","Ecosystem","Wallet"],requiresAuth:!0,logModule:"ADMIN_ECO",logTitle:"Get Master Wallet Options",responses:{200:{description:"Ecosystem master wallet options retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{value:{type:"string"},label:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("EcosystemBlockchain"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,ctx:a}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)(401,"Unauthorized");try{null==a||a.step("Fetching existing master wallets");const e=await db_1.models.ecosystemMasterWallet.findAll({attributes:["chain"]}),t=new Set(e.map(e=>e.chain)),l=["SOL","TRON","XMR","TON","MO"],s=await db_1.models.ecosystemBlockchain.findAll({where:{chain:{[sequelize_1.Op.in]:l}}}),r=[{value:"ETH",label:"Ethereum"},{value:"BSC",label:"Binance Smart Chain"},{value:"POLYGON",label:"Polygon"},{value:"FTM",label:"Fantom"},{value:"OPTIMISM",label:"Optimism"},{value:"ARBITRUM",label:"Arbitrum"},{value:"BASE",label:"Syscoin"},{value:"CELO",label:"Celo"},{value:"BTC",label:"Bitcoin"},{value:"LTC",label:"Litecoin"},{value:"DOGE",label:"Dogecoin"},{value:"DASH",label:"Dash"}];s.forEach(e=>{if(e.status&&e.chain){const t=chains_1.chainConfigs[e.chain],a=(null==t?void 0:t.currency)||e.chain;r.push({value:e.chain,label:`${e.chain} (${a})`})}});const i=r.filter(e=>!t.has(e.value));null==a||a.success("Retrieved master wallet options");return i}catch(e){throw(0,error_1.createError)(500,"An error occurred while fetching ecosystem master wallet options")}};