"use strict";async function storeCustodialWallet(e,t,s){return await db_1.models.ecosystemCustodialWallet.create({masterWalletId:e,address:s,network:process.env[`${t}_NETWORK`]||"mainnet",chain:t,status:"ACTIVE"})}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;exports.storeCustodialWallet=storeCustodialWallet;const utils_1=require("../master/utils"),db_1=require("@b/db"),ethers_1=require("ethers"),error_1=require("@b/utils/error");exports.metadata={summary:"Create a new ecosystem custodial wallet",description:"Creates a new custodial wallet by deploying a smart contract on the blockchain. The wallet is associated with a master wallet and automatically configured with the appropriate chain and network settings.",operationId:"createEcosystemCustodialWallet",tags:["Admin","Ecosystem","Wallet"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{masterWalletId:{type:"string",description:"Master wallet ID associated with the custodial wallet"}},required:["masterWalletId"]}}}},responses:{200:{description:"Custodial wallet created successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"},data:{type:"object",properties:{id:{type:"string",description:"Custodial wallet ID"},masterWalletId:{type:"string",description:"Associated master wallet ID"},address:{type:"string",description:"Wallet contract address"},chain:{type:"string",description:"Blockchain chain"},network:{type:"string",description:"Network (mainnet/testnet)"},status:{type:"string",enum:["ACTIVE","INACTIVE","SUSPENDED"]}}}}}}}}},requiresAuth:!0,permission:"create.ecosystem.custodial.wallet",logModule:"ADMIN_ECO",logTitle:"Create Ecosystem Custodial Wallet"};exports.default=async e=>{const{body:t,ctx:s}=e,{masterWalletId:a}=t;try{null==s||s.step("Validating Input");if(!a)throw(0,error_1.createError)({statusCode:400,message:"Master wallet ID is required"});null==s||s.step("Fetching Master Wallet");const e=await db_1.models.ecosystemMasterWallet.findByPk(a);if(!e)throw(0,error_1.createError)({statusCode:404,message:`Master wallet with ID ${a} not found`});null==s||s.step("Deploying Custodial Contract");const t=await(0,utils_1.deployCustodialContract)(e,s);if(!t)throw(0,error_1.createError)({statusCode:500,message:"Failed to deploy custodial wallet contract - no address returned"});null==s||s.step("Storing Custodial Wallet");const r=await storeCustodialWallet(e.id,e.chain,t);null==s||s.success("Custodial wallet created successfully");return{message:"Ecosystem custodial wallet created successfully",data:r}}catch(e){console.error("Custodial wallet creation error:",e);if((0,ethers_1.isError)(e,"INSUFFICIENT_FUNDS"))throw(0,error_1.createError)({statusCode:400,message:"Insufficient funds in master wallet to deploy custodial contract"});if(e.message.includes("Provider not initialized"))throw(0,error_1.createError)({statusCode:503,message:`Blockchain provider for ${t.masterWalletId?"selected chain":"unknown chain"} is not configured`});if(e.message.includes("Smart contract ABI or Bytecode not found"))throw(0,error_1.createError)({statusCode:500,message:"Custodial wallet smart contract files are missing - please contact administrator"});throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to create custodial wallet"})}};