"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk updates ecosystem token status",description:"Updates the status (active/inactive) for multiple ecosystem tokens simultaneously. Use this endpoint to enable or disable tokens in bulk.",operationId:"bulkUpdateEcosystemTokenStatus",tags:["Admin","Ecosystem","Token"],logModule:"ADMIN_ECO",logTitle:"Bulk update token status",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of ecosystem token IDs to update",items:{type:"string"}},status:{type:"boolean",description:"New status to apply to the ecosystem tokens (true for active, false for inactive)"}},required:["ids","status"]}}}},responses:{200:{description:"Ecosystem token status updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:errors_1.badRequestResponse,401:query_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Ecosystem Token"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"edit.ecosystem.token"};exports.default=async e=>{const{body:t,ctx:s}=e,{ids:o,status:r}=t;null==s||s.step(`Updating status for ${o.length} token(s) to ${r}`);const a=await(0,query_1.updateStatus)("ecosystemToken",o,r);null==s||s.success(`Status updated for ${o.length} token(s)`);return a};