"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Retrieves ecosystem token options",description:"Retrieves active ecosystem tokens formatted as selectable options for dropdowns and forms. Returns deduplicated tokens by currency symbol to prevent duplicate entries.",operationId:"getEcosystemTokenOptions",tags:["Admin","Ecosystem","Token"],requiresAuth:!0,logModule:"ADMIN_ECO",logTitle:"Get token options",responses:{200:{description:"Ecosystem token options retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",description:"Token ID"},name:{type:"string",description:"Formatted token name (CURRENCY - Name (Chain))"}}}}}}},401:query_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Ecosystem Token"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");try{null==t||t.step("Fetching active ecosystem tokens");const e=await db_1.models.ecosystemToken.findAll({where:{status:!0}});null==t||t.step("Deduplicating tokens by currency");const r=new Set,s=[];for(const t of e)if(!r.has(t.currency)){r.add(t.currency);s.push({id:t.id,name:`${t.currency} - ${t.name} (${t.chain})`})}null==t||t.success("Token options retrieved successfully");return s}catch(e){null==t||t.fail(e.message);throw(0,error_1.createError)(500,"An error occurred while fetching ecosystem tokens")}};