"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk deletes ecosystem tokens",description:"Deletes multiple ecosystem tokens by their IDs. This operation performs a soft delete, marking the tokens as deleted without removing them from the database permanently.",operationId:"bulkDeleteEcosystemTokens",tags:["Admin","Ecosystem","Token"],parameters:(0,query_1.commonBulkDeleteParams)("Ecosystem Tokens"),logModule:"ADMIN_ECO",logTitle:"Bulk delete tokens",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of ecosystem token IDs to delete"}},required:["ids"]}}}},responses:{200:{description:"Ecosystem tokens deleted successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:errors_1.badRequestResponse,401:query_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Ecosystem Token"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"delete.ecosystem.token"};exports.default=async e=>{const{body:s,query:t,ctx:o}=e,{ids:r}=s;null==o||o.step(`Deleting ${r.length} token(s)`);const n=await(0,query_1.handleBulkDelete)({model:"ecosystemToken",ids:r,query:t});null==o||o.success(`${r.length} token(s) deleted successfully`);return n};