"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk updates ecosystem market status",description:"Updates the active/inactive status for multiple ecosystem markets at once. Accepts an array of market IDs and a boolean status value to apply to all specified markets.",operationId:"bulkUpdateEcosystemMarketStatus",tags:["Admin","Ecosystem","Market"],logModule:"ADMIN_ECO",logTitle:"Bulk update market status",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of ecosystem market IDs to update (at least 1 required)",items:{type:"string",format:"uuid"}},status:{type:"boolean",description:"New status to apply to the ecosystem markets (true for active, false for inactive)"}},required:["ids","status"]}}}},responses:{200:{description:"Market status updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Ecosystem Market"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"edit.ecosystem.market"};exports.default=async e=>{const{body:t,ctx:s}=e,{ids:r,status:a}=t;null==s||s.step(`Updating status for ${r.length} market(s) to ${a}`);const o=await(0,query_1.updateStatus)("ecosystemMarket",r,a);null==s||s.success(`Market status updated for ${r.length} market(s)`);return o};