"use strict";function getEVMProvider(e){const t=evmProviderMapping[e];if(!t)throw(0,error_1.createError)({statusCode:400,message:`Unsupported EVM chain: ${e}`});return new ethers_1.JsonRpcProvider(t.url,t.chainId)}async function getTokenDeploymentCostForEVM(e){const t=getEVMProvider(e),r=BigInt(5e5),o=(await t.getFeeData()).gasPrice;if(!o)throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch gas price"});const n=o*r;return(0,ethers_1.formatEther)(n)}async function getTokenDeploymentCostForSolana(){const e=process.env.SOLANA_RPC_URL||"https://api.mainnet-beta.solana.com",t=new web3_js_1.Connection(e);return(await t.getMinimumBalanceForRentExemption(165)/web3_js_1.LAMPORTS_PER_SOL).toFixed(4)}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const ethers_1=require("ethers"),web3_js_1=require("@solana/web3.js"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors"),db_1=require("@b/db"),evmProviderMapping={ETH:{url:process.env.ETH_MAINNET_RPC||"https://eth.public-rpc.com",chainId:1},ARBITRUM:{url:process.env.ARBIRUM_MAINNET_RPC||"https://arbitrum.public-rpc.com",chainId:42161},BASE:{url:process.env.BASE_MAINNET_RPC||"https://base.blockchain.rpc",chainId:8453},BSC:{url:process.env.BSC_MAINNET_RPC||"https://bscrpc.com",chainId:56},CELO:{url:process.env.CELO_MAINNET_RPC||"https://forno.celo.org",chainId:42220},FTM:{url:process.env.FTM_MAINNET_RPC||"https://fantom-mainnet.public.blastapi.io/",chainId:250},OPTIMISM:{url:process.env.OPTIMISM_MAINNET_RPC||"https://mainnet.optimism.io",chainId:10},POLYGON:{url:process.env.POLYGON_MATIC_RPC||"https://polygon-rpc.com",chainId:137},RSK:{url:process.env.RSK_MAINNET_RPC||"https://public-node.rsk.co",chainId:30}};exports.metadata={summary:"Get master wallet balance and token deployment cost",description:"Retrieves the master wallet balance for a specified blockchain and calculates the estimated token deployment cost. For EVM-compatible chains (ETH, ARBITRUM, BASE, BSC, CELO, FTM, OPTIMISM, POLYGON, RSK), it uses ethers.js to estimate gas costs. For Solana, it calculates the rent-exempt minimum for token account creation.",operationId:"getEcosystemBlockchainBalance",tags:["Admin","Ecosystem","Blockchain"],requiresAuth:!0,logModule:"ADMIN_ECO",logTitle:"Get wallet balance and token deployment cost",parameters:[{index:0,name:"chain",in:"query",required:!0,schema:{type:"string",enum:["ETH","ARBITRUM","BASE","BSC","CELO","FTM","OPTIMISM","POLYGON","RSK","SOL"]},description:"The blockchain chain identifier for which to retrieve the wallet balance and token deployment cost."}],responses:{200:{description:"Master wallet balance and token deployment cost retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{wallet:{type:"object",properties:{id:{type:"string",format:"uuid",description:"Master wallet unique identifier"},chain:{type:"string",description:"Blockchain chain identifier"},currency:{type:"string",description:"Native currency symbol"},address:{type:"string",description:"Wallet address"},balance:{type:"number",description:"Current wallet balance"}},required:["id","chain","currency","address","balance"]},tokenDeploymentCost:{type:"string",description:"Estimated cost to deploy a token in native currency"}},required:["wallet","tokenDeploymentCost"]}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Master wallet"),500:errors_1.serverErrorResponse},permission:"view.ecosystem.blockchain"};exports.default=async e=>{const{user:t,query:r,ctx:o}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)(401,"Unauthorized");const n=(r.chain||"").toUpperCase();if(!n)throw(0,error_1.createError)(400,"Chain parameter is required");try{null==o||o.step(`Retrieving master wallet for chain ${n}`);const e=await db_1.models.ecosystemMasterWallet.findOne({where:{chain:n,status:!0}});if(!e)throw(0,error_1.createError)(404,"Master wallet not found for the specified chain");null==o||o.step("Calculating token deployment cost");let t;t="SOL"===n?await getTokenDeploymentCostForSolana():evmProviderMapping[n]?await getTokenDeploymentCostForEVM(n):"Token deployment cost not available for this chain";null==o||o.success("Balance and cost retrieved successfully");return{wallet:{id:e.id,chain:e.chain,currency:e.currency,address:e.address,balance:e.balance},tokenDeploymentCost:t}}catch(e){null==o||o.fail(e.message);throw(0,error_1.createError)(500,e.message)}};