"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),utils_1=require("./utils"),wallet_1=require("@b/services/wallet"),error_1=require("@b/utils/error");exports.metadata={summary:"Bulk updates the status of ecommerce orders",operationId:"bulkUpdateEcommerceOrderStatus",tags:["Admin","Ecommerce Orders"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of ecommerce order IDs to update",items:{type:"string"}},status:{type:"string",enum:["PENDING","COMPLETED","CANCELLED","REJECTED"],description:"New status to apply to the ecommerce orders"}},required:["ids","status"]}}}},responses:(0,query_1.updateRecordResponses)("Ecommerce Order"),requiresAuth:!0,permission:"edit.ecommerce.order",logModule:"ADMIN_ECOM",logTitle:"Bulk update order status"};exports.default=async e=>{const{body:r,ctx:t}=e,{ids:s,status:a}=r;null==t||t.step(`Finding ${s.length} orders`);const o=await db_1.models.ecommerceOrder.findAll({where:{id:s}});if(!o.length)throw(0,error_1.createError)({statusCode:404,message:"Orders not found"});null==t||t.step("Validating order statuses and updating");await db_1.sequelize.transaction(async e=>{for(const r of o){if("PENDING"!==r.status)throw(0,error_1.createError)({statusCode:400,message:`Order ${r.id} status is not PENDING`});const s=await db_1.models.transaction.findOne({where:{referenceId:r.id}});if(!s)throw(0,error_1.createError)({statusCode:404,message:`Transaction not found for order ${r.id}`});const o=await db_1.models.wallet.findByPk(s.walletId);if(!o)throw(0,error_1.createError)({statusCode:404,message:`Wallet not found for transaction ${s.id}`});r.status=a;await r.save({transaction:e});if("CANCELLED"===a||"REJECTED"===a){null==t||t.step(`Refunding order ${r.id} amount via wallet service`);const d=`ecom_order_refund_${r.id}`;await wallet_1.walletService.credit({idempotencyKey:d,userId:r.userId,walletId:o.id,walletType:o.type,currency:o.currency,amount:s.amount,operationType:"REFUND",referenceId:r.id,description:`Refund for ${a.toLowerCase()} order ${r.id}`,metadata:{orderId:r.id,transactionId:s.id,status:a},transaction:e})}}null==t||t.step("Sending status update emails");await Promise.all(o.map(async e=>{const r=await db_1.models.user.findByPk(e.userId);await(0,utils_1.sendOrderStatusUpdateEmail)(r,e,a,t)}))});null==t||t.success(`Successfully updated status for ${s.length} orders`)};