"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query");exports.metadata={summary:"Bulk updates the status of ecommerce discounts",operationId:"bulkUpdateEcommerceDiscountStatus",description:"Updates the active/inactive status of multiple ecommerce discounts simultaneously. This allows enabling or disabling multiple discount codes in a single operation. Inactive discounts cannot be used by customers during checkout.",tags:["Admin","Ecommerce","Discount"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of ecommerce discount IDs to update",items:{type:"string"}},status:{type:"boolean",description:"New status to apply to the ecommerce discounts (true for active, false for inactive)"}},required:["ids","status"]}}}},responses:(0,query_1.updateRecordResponses)("Ecommerce Discount"),requiresAuth:!0,permission:"edit.ecommerce.discount",logModule:"ADMIN_ECOM",logTitle:"Bulk update discount status"};exports.default=async e=>{const{body:t,ctx:s}=e,{ids:o,status:u}=t;null==s||s.step(`Validating ${o.length} discount IDs`);null==s||s.step(`Updating status to ${u} for ${o.length} discounts`);const i=await(0,query_1.updateStatus)("ecommerceDiscount",o,u);null==s||s.success(`Successfully updated status for ${o.length} discounts`);return i};