"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query");exports.metadata={summary:"Bulk deletes ecommerce discounts by IDs",operationId:"bulkDeleteEcommerceDiscounts",tags:["Admin","Ecommerce","Discount"],description:"Deletes multiple ecommerce discount records in a single operation. This endpoint accepts an array of discount IDs and removes them from the database. All associated discount codes and their product relationships will be permanently deleted.",parameters:(0,query_1.commonBulkDeleteParams)("E-commerce Discounts"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of e-commerce discount IDs to delete"}},required:["ids"]}}}},responses:(0,query_1.commonBulkDeleteResponses)("E-commerce Discounts"),requiresAuth:!0,permission:"delete.ecommerce.discount",logModule:"ADMIN_ECOM",logTitle:"Bulk delete discounts"};exports.default=async e=>{const{body:t,query:s,ctx:o}=e,{ids:r}=t;null==o||o.step(`Validating ${r.length} discount IDs`);null==o||o.step("Performing bulk delete operation");const c=await(0,query_1.handleBulkDelete)({model:"ecommerceDiscount",ids:r,query:s});null==o||o.success(`Successfully deleted ${r.length} discounts`);return c};