"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Gets ecommerce category options for selection",description:"Retrieves a list of active ecommerce categories formatted as value-label pairs for use in dropdown menus and selection components. Only returns categories with status set to true.",operationId:"getEcommerceCategoryOptions",tags:["Admin","Ecommerce","Category"],requiresAuth:!0,responses:{200:{description:"Category options retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{value:{type:"string",description:"Category ID"},label:{type:"string",description:"Category name"}},required:["value","label"]}}}}},401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Ecommerce category"),500:errors_1.serverErrorResponse},logModule:"ADMIN_ECOM",logTitle:"Get category options"};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");try{null==t||t.step("Fetching active categories");const e=await db_1.models.ecommerceCategory.findAll({where:{status:!0},attributes:["id","name"],order:[["name","ASC"]]});null==t||t.step("Formatting category options");const r=e.map(e=>({value:e.id,label:e.name}));null==t||t.success(`Retrieved ${r.length} category options`);return r}catch(e){null==t||t.fail("Failed to fetch category options");throw(0,error_1.createError)(500,"An error occurred while fetching ecommerce categories")}};