"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"List All Copy Trading Transactions",description:"Returns a paginated list of all copy trading transactions with filtering options. Supports filtering by transaction type (ALLOCATION, DEALLOCATION, PROFIT, LOSS, PROFIT_SHARE, PLATFORM_FEE, REFUND), user ID, leader ID, follower ID, minimum amount, and date range. Includes summary statistics grouped by transaction type.",operationId:"getAdminCopyTradingTransactions",tags:["Admin","Copy Trading","Transactions"],requiresAuth:!0,permission:"access.copy_trading",demoMask:["items.user.email"],logModule:"ADMIN_COPY",logTitle:"Get Copy Trading Transactions",parameters:[{name:"type",in:"query",required:!1,schema:{type:"string",enum:["ALLOCATION","DEALLOCATION","PROFIT","LOSS","PROFIT_SHARE","PLATFORM_FEE","REFUND"]},description:"Filter by transaction type"},{name:"userId",in:"query",required:!1,schema:{type:"string"},description:"Filter by user ID"},{name:"leaderId",in:"query",required:!1,schema:{type:"string"},description:"Filter by leader ID"},{name:"followerId",in:"query",required:!1,schema:{type:"string"},description:"Filter by follower/subscription ID"},{name:"minAmount",in:"query",required:!1,schema:{type:"number"},description:"Minimum transaction amount"},{name:"dateFrom",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Filter from date (inclusive)"},{name:"dateTo",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Filter until date (inclusive)"},{name:"page",in:"query",schema:{type:"integer",default:1},description:"Page number for pagination"},{name:"limit",in:"query",schema:{type:"integer",default:20},description:"Number of items per page (max 100)"}],responses:{200:{description:"Transactions retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",description:"List of copy trading transactions",items:{type:"object",properties:{id:{type:"string"},userId:{type:"string"},leaderId:{type:"string",nullable:!0},followerId:{type:"string",nullable:!0},tradeId:{type:"string",nullable:!0},type:{type:"string"},amount:{type:"number"},currency:{type:"string"},fee:{type:"number"},balanceBefore:{type:"number"},balanceAfter:{type:"number"},description:{type:"string"},createdAt:{type:"string",format:"date-time"},user:{type:"object"},leader:{type:"object",nullable:!0},follower:{type:"object",nullable:!0},trade:{type:"object",nullable:!0}}}},pagination:{type:"object",properties:{total:{type:"integer"},page:{type:"integer"},limit:{type:"integer"},totalPages:{type:"integer"}}},summary:{type:"array",description:"Summary statistics grouped by transaction type",items:{type:"object",properties:{type:{type:"string"},total:{type:"number"},count:{type:"integer"}}}}}}}}},401:errors_1.unauthorizedResponse,403:errors_1.forbiddenResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{const{user:t,query:r,ctx:i}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==i||i.step("Fetching copy trading transactions");const a={};r.type&&(a.type=r.type);r.userId&&(a.userId=r.userId);r.leaderId&&(a.leaderId=r.leaderId);r.followerId&&(a.followerId=r.followerId);r.minAmount&&(a.amount={[sequelize_1.Op.gte]:parseFloat(r.minAmount)});if(r.dateFrom||r.dateTo){a.createdAt={};r.dateFrom&&(a.createdAt[sequelize_1.Op.gte]=new Date(r.dateFrom));r.dateTo&&(a.createdAt[sequelize_1.Op.lte]=new Date(r.dateTo+"T23:59:59.999Z"))}const s=parseInt(r.page)||1,n=Math.min(parseInt(r.limit)||20,100),o=(s-1)*n,{count:d,rows:l}=await db_1.models.copyTradingTransaction.findAndCountAll({where:a,include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email"]},{model:db_1.models.copyTradingLeader,as:"leader",attributes:["id","displayName"],required:!1},{model:db_1.models.copyTradingFollower,as:"follower",attributes:["id"],required:!1},{model:db_1.models.copyTradingTrade,as:"trade",attributes:["id","symbol","side","amount"],required:!1}],order:[["createdAt","DESC"]],limit:n,offset:o}),p=await db_1.models.copyTradingTransaction.findAll({attributes:["type",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"total"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],group:["type"]});null==i||i.success(`Retrieved ${d} copy trading transactions`);return{items:l.map(e=>e.toJSON()),pagination:{total:d,page:s,limit:n,totalPages:Math.ceil(d/n)},summary:p.map(e=>({type:e.type,total:parseFloat(e.get("total"))||0,count:parseInt(e.get("count"))||0}))}};