"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"List all copy trades",description:"Returns a paginated list of all copy trading trades with filtering options. Supports filtering by status, leader ID, follower ID, symbol, side (BUY/SELL), and trade type (leader/follower). Includes leader and follower information with associated user details.",operationId:"getAdminCopyTradingTrades",tags:["Admin","Copy Trading","Trades"],requiresAuth:!0,permission:"access.copy_trading",logModule:"ADMIN_COPY",logTitle:"Get Copy Trading Trades",parameters:[{name:"page",in:"query",schema:{type:"integer",default:1},description:"Page number for pagination"},{name:"limit",in:"query",schema:{type:"integer",default:10},description:"Number of items per page"},{name:"status",in:"query",schema:{type:"string"},description:"Filter by trade status"},{name:"leaderId",in:"query",schema:{type:"string"},description:"Filter by leader ID"},{name:"followerId",in:"query",schema:{type:"string"},description:"Filter by follower ID"},{name:"symbol",in:"query",schema:{type:"string"},description:"Filter by trading symbol"},{name:"side",in:"query",schema:{type:"string",enum:["BUY","SELL"]},description:"Filter by trade side"},{name:"type",in:"query",schema:{type:"string",enum:["leader","follower"]},description:"Filter by leader trades only or follower trades only"}],responses:{200:{description:"Trades retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",description:"List of copy trading trades",items:{type:"object",properties:{id:{type:"string"},leaderId:{type:"string"},followerId:{type:"string",nullable:!0},symbol:{type:"string"},side:{type:"string",enum:["BUY","SELL"]},amount:{type:"number"},price:{type:"number"},status:{type:"string"},profit:{type:"number"},fee:{type:"number"},latencyMs:{type:"integer"},createdAt:{type:"string",format:"date-time"},leader:{type:"object"},follower:{type:"object",nullable:!0}}}},pagination:{type:"object",properties:{total:{type:"integer"},page:{type:"integer"},limit:{type:"integer"},totalPages:{type:"integer"}}}}}}}},401:errors_1.unauthorizedResponse,403:errors_1.forbiddenResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{const{user:t,query:r,ctx:s}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==s||s.step("Fetching copy trading trades");const i=parseInt(r.page)||1,a=parseInt(r.limit)||10,o=(i-1)*a,l={};r.status&&(l.status=r.status);r.leaderId&&(l.leaderId=r.leaderId);r.followerId&&(l.followerId=r.followerId);r.symbol&&(l.symbol=r.symbol);r.side&&(l.side=r.side);"leader"===r.type?l.followerId=null:"follower"===r.type&&(l.followerId={[sequelize_1.Op.ne]:null});const{count:d,rows:n}=await db_1.models.copyTradingTrade.findAndCountAll({where:l,include:[{model:db_1.models.copyTradingLeader,as:"leader",attributes:["id","displayName","userId"],include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName"]}]},{model:db_1.models.copyTradingFollower,as:"follower",attributes:["id","userId"],include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName"]}]}],limit:a,offset:o,order:[["createdAt","DESC"]]});null==s||s.success(`Retrieved ${d} copy trading trades`);return{items:n,pagination:{total:d,page:i,limit:a,totalPages:Math.ceil(d/a)}}};