"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get Copy Trading Admin Dashboard",description:"Retrieves comprehensive admin dashboard statistics for copy trading including performance metrics, growth analytics, top performers, and system health.",operationId:"getCopyTradingAdminDashboard",tags:["Admin","Copy Trading","Dashboard"],requiresAuth:!0,logModule:"ADMIN_COPY",logTitle:"Get Copy Trading Dashboard",permission:"access.copy_trading",demoMask:["pendingApplications.user.email","topLeaders.user.email"],responses:{200:{description:"Dashboard data retrieved successfully"},401:errors_1.unauthorizedResponse,403:errors_1.forbiddenResponse,500:errors_1.serverErrorResponse}};const calcGrowth=(e,t)=>{if(0===t)return e>0?"+100%":"0%";const a=(e-t)/t*100;return`${a>=0?"+":""}${a.toFixed(1)}%`};exports.default=async e=>{const{user:t,ctx:a}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==a||a.step("Get Copy Trading Dashboard");const r=new Date,s=new Date(r.getFullYear(),r.getMonth(),r.getDate()),o=new Date(s);o.setDate(o.getDate()-1);const i=new Date(s);i.setDate(i.getDate()-7);const l=new Date(s);l.setDate(l.getDate()-14);const d=new Date(s);d.setMonth(d.getMonth()-1);const n=(await db_1.models.copyTradingLeader.findAll({attributes:["status",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],group:["status"],raw:!0})).reduce((e,t)=>{e[t.status]=parseInt(t.count);return e},{}),u=Object.values(n).reduce((e,t)=>e+("number"==typeof t?t:0),0),c=await db_1.models.copyTradingLeader.count({where:{createdAt:{[sequelize_1.Op.lt]:i}}}),p=calcGrowth(u,c),w=(await db_1.models.copyTradingFollower.findAll({attributes:["status",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],group:["status"],raw:!0})).reduce((e,t)=>{e[t.status]=parseInt(t.count);return e},{}),m=Object.values(w).reduce((e,t)=>e+("number"==typeof t?t:0),0),_=await db_1.models.copyTradingFollower.count({where:{createdAt:{[sequelize_1.Op.lt]:i}}}),g=calcGrowth(m,_),T=await db_1.models.copyTradingFollowerAllocation.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("quoteAmount")),"total"]],where:{isActive:!0},raw:!0}),b=parseFloat((null==T?void 0:T.total)||"0"),f=await db_1.models.copyTradingTrade.count({where:{createdAt:{[sequelize_1.Op.gte]:s}}}),D=await db_1.models.copyTradingTrade.count({where:{createdAt:{[sequelize_1.Op.gte]:o,[sequelize_1.Op.lt]:s}}}),y=calcGrowth(f,D),h=await db_1.models.copyTradingTrade.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("cost")),"volume"]],where:{createdAt:{[sequelize_1.Op.gte]:s}},raw:!0}),v=parseFloat((null==h?void 0:h.volume)||"0"),q=await db_1.models.copyTradingTrade.count({where:{status:"CLOSED"}}),A=await db_1.models.copyTradingTrade.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("cost")),"volume"]],where:{status:"CLOSED"},raw:!0}),O=parseFloat((null==A?void 0:A.volume)||"0"),z=await db_1.models.copyTradingTrade.count({where:{status:{[sequelize_1.Op.in]:["FAILED","REPLICATION_FAILED"]},createdAt:{[sequelize_1.Op.gte]:s}}}),E=f>0?z/f*100:0,S=await db_1.models.copyTradingTransaction.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"total"]],where:{type:"PROFIT_SHARE",status:"COMPLETED"},raw:!0}),C=parseFloat((null==S?void 0:S.total)||"0"),N=await db_1.models.copyTradingTransaction.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"total"]],where:{type:"PROFIT_SHARE",status:"COMPLETED",createdAt:{[sequelize_1.Op.gte]:d}},raw:!0}),L=parseFloat((null==N?void 0:N.total)||"0"),I=await db_1.models.copyTradingLeader.findAll({where:{status:"ACTIVE"},include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.copyTradingFollower,as:"followers",attributes:["id"],where:{status:"ACTIVE"},required:!1}],limit:5}),F=await Promise.all(I.map(async e=>{var t,a;const r=e.toJSON(),s=await db_1.models.copyTradingTrade.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalTrades"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("profit")),"totalProfit"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN profit > 0 THEN 1 ELSE 0 END")),"winningTrades"]],where:{leaderId:e.id,isLeaderTrade:!0,status:"CLOSED"},raw:!0}),o=parseInt((null==s?void 0:s.totalTrades)||"0"),i=parseInt((null==s?void 0:s.winningTrades)||"0"),l=parseFloat((null==s?void 0:s.totalProfit)||"0"),d=o>0?i/o*100:0;return{id:r.id,displayName:r.displayName,avatar:r.avatar||(null===(t=r.user)||void 0===t?void 0:t.avatar),tradingStyle:r.tradingStyle,riskLevel:r.riskLevel,followerCount:(null===(a=r.followers)||void 0===a?void 0:a.length)||0,totalTrades:o,winRate:d.toFixed(1),totalProfit:l}}));F.sort((e,t)=>t.followerCount-e.followerCount);const P=[];for(let e=6;e>=0;e--){const t=new Date(s);t.setDate(t.getDate()-e);const a=new Date(t);a.setDate(a.getDate()+1);const r=await db_1.models.copyTradingTrade.count({where:{createdAt:{[sequelize_1.Op.between]:[t,a]}}}),o=await db_1.models.copyTradingTrade.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("cost")),"volume"]],where:{createdAt:{[sequelize_1.Op.between]:[t,a]}},raw:!0}),i=await db_1.models.copyTradingTrade.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("profit")),"profit"]],where:{status:"CLOSED",createdAt:{[sequelize_1.Op.between]:[t,a]}},raw:!0});P.push({date:t.toLocaleDateString("en-US",{month:"short",day:"numeric"}),trades:r,volume:parseFloat((null==o?void 0:o.volume)||"0"),profit:parseFloat((null==i?void 0:i.profit)||"0")})}const M=e=>e.toISOString().split("T")[0],U=[];for(let e=6;e>=0;e--){const t=new Date(s);t.setDate(t.getDate()-e);const a=new Date(t);a.setDate(a.getDate()+1);const r=await db_1.models.copyTradingLeader.count({where:{createdAt:{[sequelize_1.Op.lt]:a}}});U.push({date:M(t),value:r})}const R=[];for(let e=6;e>=0;e--){const t=new Date(s);t.setDate(t.getDate()-e);const a=new Date(t);a.setDate(a.getDate()+1);const r=await db_1.models.copyTradingFollower.count({where:{createdAt:{[sequelize_1.Op.lt]:a}}});R.push({date:M(t),value:r})}const G=[];for(let e=6;e>=0;e--){const t=new Date(s);t.setDate(t.getDate()-e);const a=new Date(t);a.setDate(a.getDate()+1);const r=await db_1.models.copyTradingTransaction.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"total"]],where:{type:"PROFIT_SHARE",status:"COMPLETED",createdAt:{[sequelize_1.Op.lt]:a}},raw:!0});G.push({date:M(t),value:parseFloat((null==r?void 0:r.total)||"0")})}const x=[];for(let e=6;e>=0;e--){const t=new Date(s);t.setDate(t.getDate()-e);const a=new Date(t);a.setDate(a.getDate()+1);const r=await db_1.models.copyTradingFollowerAllocation.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("quoteAmount")),"total"]],where:{isActive:!0,createdAt:{[sequelize_1.Op.lt]:a}},raw:!0});x.push({date:M(t),value:parseFloat((null==r?void 0:r.total)||"0")})}const k=await db_1.models.copyTradingLeader.findAll({attributes:["tradingStyle",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],where:{status:"ACTIVE"},group:["tradingStyle"],raw:!0}),V=await db_1.models.copyTradingLeader.findAll({attributes:["riskLevel",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],where:{status:"ACTIVE"},group:["riskLevel"],raw:!0}),H=await db_1.models.copyTradingLeader.findAll({where:{status:"PENDING"},include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]}],order:[["createdAt","ASC"]],limit:5}),J=await db_1.models.copyTradingAuditLog.findAll({include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.user,as:"admin",attributes:["id","firstName","lastName","avatar"]}],order:[["createdAt","DESC"]],limit:10}),j=await db_1.models.copyTradingTrade.findAll({attributes:["id","symbol","side","type","amount","price","cost","profit","profitPercent","status","isLeaderTrade","createdAt"],include:[{model:db_1.models.copyTradingLeader,as:"leader",attributes:["id","displayName"]}],order:[["createdAt","DESC"]],limit:10}),Y=await db_1.models.copyTradingTrade.count({where:{status:{[sequelize_1.Op.in]:["PENDING","PENDING_REPLICATION"]}}});let $=100;E>10?$-=30:E>5?$-=15:E>2&&($-=5);Y>100?$-=20:Y>50?$-=10:Y>20&&($-=5);const W=$>=90?"Excellent":$>=70?"Good":$>=50?"Fair":"Needs Attention";null==a||a.success("Copy Trading Dashboard retrieved successfully");return{stats:{leaders:{total:u,active:n.ACTIVE||0,pending:n.PENDING||0,suspended:n.SUSPENDED||0,rejected:n.REJECTED||0,growth:p},followers:{total:m,active:w.ACTIVE||0,paused:w.PAUSED||0,stopped:w.STOPPED||0,growth:g},trades:{today:f,todayGrowth:y,completed:q,volume:O,todayVolume:v,failureRate:E.toFixed(2)},financial:{totalAllocated:b,platformRevenue:C,monthRevenue:L},health:{score:$,status:W,pendingTrades:Y,failureRate:E.toFixed(2)}},distributions:{tradingStyle:k.map(e=>({style:e.tradingStyle,count:parseInt(e.count)})),riskLevel:V.map(e=>({level:e.riskLevel,count:parseInt(e.count)}))},tradeTimeline:P,sparklines:{leaders:U,followers:R,revenue:G,allocation:x},topLeaders:F,recentTrades:j.map(e=>e.toJSON()),pendingApplications:H.map(e=>e.toJSON()),recentActivity:J.map(e=>e.toJSON())}};