"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get copy trading analytics",description:"Returns comprehensive analytics for copy trading including leader stats, follower stats, trade stats, revenue metrics, top performers, and daily statistics for charting. Supports filtering by time period (day, week, month, all).",operationId:"getCopyTradingAnalytics",tags:["Admin","Copy Trading","Analytics"],requiresAuth:!0,logModule:"ADMIN_COPY",logTitle:"Get Copy Trading Analytics",permission:"access.copy_trading",parameters:[{name:"period",in:"query",schema:{type:"string",enum:["day","week","month","all"],default:"month"},description:"Time period for analytics data"}],responses:{200:{description:"Analytics data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{leaders:{type:"object",description:"Leader statistics"},followers:{type:"object",description:"Follower statistics"},trades:{type:"object",description:"Trade statistics"},revenue:{type:"object",description:"Platform revenue statistics"},topLeaders:{type:"array",description:"Top 10 performing leaders by ROI"},dailyStats:{type:"array",description:"Daily statistics for the last 30 days"},period:{type:"string",description:"Time period used for analytics"}}}}}},401:errors_1.unauthorizedResponse,403:errors_1.forbiddenResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var t,s;const{user:i,query:r,ctx:a}=e;if(!(null==i?void 0:i.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const l=r.period||"month";let o={};const n=new Date;switch(l){case"day":o={[sequelize_1.Op.gte]:new Date(n.setDate(n.getDate()-1))};break;case"week":o={[sequelize_1.Op.gte]:new Date(n.setDate(n.getDate()-7))};break;case"month":o={[sequelize_1.Op.gte]:new Date(n.setMonth(n.getMonth()-1))};break;default:o={}}null==a||a.step("Get Copy Trading Analytics");const d=await db_1.models.copyTradingLeader.findAll({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalLeaders"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN \"status\" = 'ACTIVE' THEN 1 ELSE 0 END")),"activeLeaders"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN \"status\" = 'PENDING' THEN 1 ELSE 0 END")),"pendingLeaders"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("totalFollowers")),"totalFollowersSum"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("winRate")),"avgWinRate"],[(0,sequelize_1.fn)("AVG",(0,sequelize_1.col)("roi")),"avgRoi"]],raw:!0}),u=await db_1.models.copyTradingFollower.findAll({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalSubscriptions"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN \"status\" = 'ACTIVE' THEN 1 ELSE 0 END")),"activeSubscriptions"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("totalProfit")),"totalProfit"]],raw:!0}),c={};Object.keys(o).length>0&&(c.createdAt=o);const p=await db_1.models.copyTradingTrade.findAll({where:c,attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"totalTrades"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN \"status\" = 'CLOSED' THEN 1 ELSE 0 END")),"closedTrades"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)('CASE WHEN "profit" > 0 THEN 1 ELSE 0 END')),"profitableTrades"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("profit")),"totalProfit"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalVolume"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("fee")),"totalFees"]],raw:!0}),_={};Object.keys(o).length>0&&(_.createdAt=o);const f=await db_1.models.copyTradingTransaction.findAll({where:{..._,type:"PLATFORM_FEE"},attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalPlatformFees"]],raw:!0}),q=await db_1.models.copyTradingTransaction.findAll({where:{..._,type:"PROFIT_SHARE"},attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalProfitShares"]],raw:!0}),y=await db_1.models.copyTradingLeader.findAll({where:{status:"ACTIVE"},order:[["roi","DESC"]],limit:10,include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","avatar"]}]}),z=await db_1.models.copyTradingTrade.findAll({where:{createdAt:{[sequelize_1.Op.gte]:new Date(Date.now()-2592e6)}},attributes:[[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt")),"date"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"trades"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("profit")),"profit"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"volume"]],group:[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt"))],order:[[(0,sequelize_1.fn)("DATE",(0,sequelize_1.col)("createdAt")),"ASC"]],raw:!0});null==a||a.success("Get Copy Trading Analytics retrieved successfully");return{leaders:d[0]||{},followers:u[0]||{},trades:p[0]||{},revenue:{platformFees:(null===(t=f[0])||void 0===t?void 0:t.totalPlatformFees)||0,profitShares:(null===(s=q[0])||void 0===s?void 0:s.totalProfitShares)||0},topLeaders:y,dailyStats:z,period:l}};