"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.phaseStatusSchema=exports.forcePhaseSchema=exports.volatilityConfigUpdateSchema=exports.priceModeUpdateSchema=exports.biasUpdateSchema=exports.targetPriceUpdateSchema=exports.statusChangeSchema=exports.aiMarketMakerPoolStoreSchema=exports.aiMarketMakerStoreSchema=exports.pnlReportSchema=exports.marketPerformanceSchema=exports.analyticsOverviewSchema=exports.aiMarketMakerHistorySchema=exports.aiMarketMakerSettingsUpdateSchema=exports.aiMarketMakerSettingsSchema=exports.aiBotUpdateSchema=exports.aiBotSchema=exports.poolWithdrawSchema=exports.poolDepositSchema=exports.aiMarketMakerPoolSchema=exports.aiMarketMakerUpdateSchema=exports.aiMarketMakerCreateSchema=exports.aiMarketMakerSchema=void 0;const schema_1=require("@b/utils/schema"),id=(0,schema_1.baseStringSchema)("ID of the AI Market Maker"),marketId=(0,schema_1.baseStringSchema)("ID of the ecosystem market"),status=(0,schema_1.baseEnumSchema)("Current status",["ACTIVE","PAUSED","STOPPED"]),targetPrice=(0,schema_1.baseNumberSchema)("Target price for the market"),priceRangeLow=(0,schema_1.baseNumberSchema)("Lower bound of price range"),priceRangeHigh=(0,schema_1.baseNumberSchema)("Upper bound of price range"),aggressionLevel=(0,schema_1.baseEnumSchema)("Aggression level",["CONSERVATIVE","MODERATE","AGGRESSIVE"]),maxDailyVolume=(0,schema_1.baseNumberSchema)("Maximum daily trading volume"),currentDailyVolume=(0,schema_1.baseNumberSchema)("Current daily trading volume"),volatilityThreshold=(0,schema_1.baseNumberSchema)("Volatility threshold for auto-pause"),pauseOnHighVolatility=(0,schema_1.baseBooleanSchema)("Whether to pause on high volatility"),realLiquidityPercent=(0,schema_1.baseNumberSchema)("Percentage of orders placed as real ecosystem orders (0-100)"),createdAt=(0,schema_1.baseDateTimeSchema)("Creation timestamp"),updatedAt=(0,schema_1.baseDateTimeSchema)("Last update timestamp");exports.aiMarketMakerSchema={id:id,marketId:marketId,status:status,targetPrice:targetPrice,priceRangeLow:priceRangeLow,priceRangeHigh:priceRangeHigh,aggressionLevel:aggressionLevel,maxDailyVolume:maxDailyVolume,currentDailyVolume:currentDailyVolume,volatilityThreshold:volatilityThreshold,pauseOnHighVolatility:pauseOnHighVolatility,realLiquidityPercent:realLiquidityPercent,createdAt:createdAt,updatedAt:updatedAt};exports.aiMarketMakerCreateSchema={type:"object",properties:{marketId:(0,schema_1.baseStringSchema)("ID of the ecosystem market to enable AI for"),targetPrice:(0,schema_1.baseNumberSchema)("Initial target price"),priceRangeLow:(0,schema_1.baseNumberSchema)("Lower bound of price range"),priceRangeHigh:(0,schema_1.baseNumberSchema)("Upper bound of price range"),aggressionLevel:(0,schema_1.baseEnumSchema)("Aggression level",["CONSERVATIVE","MODERATE","AGGRESSIVE"]),maxDailyVolume:(0,schema_1.baseNumberSchema)("Maximum daily trading volume"),volatilityThreshold:(0,schema_1.baseNumberSchema)("Volatility threshold (0-100)"),pauseOnHighVolatility:(0,schema_1.baseBooleanSchema)("Pause on high volatility"),realLiquidityPercent:(0,schema_1.baseNumberSchema)("Real liquidity percentage (0-100)")},required:["marketId","targetPrice","priceRangeLow","priceRangeHigh"]};exports.aiMarketMakerUpdateSchema={type:"object",properties:{targetPrice:(0,schema_1.baseNumberSchema)("Target price"),priceRangeLow:(0,schema_1.baseNumberSchema)("Lower bound of price range"),priceRangeHigh:(0,schema_1.baseNumberSchema)("Upper bound of price range"),aggressionLevel:(0,schema_1.baseEnumSchema)("Aggression level",["CONSERVATIVE","MODERATE","AGGRESSIVE"]),maxDailyVolume:(0,schema_1.baseNumberSchema)("Maximum daily trading volume"),volatilityThreshold:(0,schema_1.baseNumberSchema)("Volatility threshold"),pauseOnHighVolatility:(0,schema_1.baseBooleanSchema)("Pause on high volatility"),realLiquidityPercent:(0,schema_1.baseNumberSchema)("Real liquidity percentage")}};const baseCurrencyBalance=(0,schema_1.baseNumberSchema)("Base currency balance"),quoteCurrencyBalance=(0,schema_1.baseNumberSchema)("Quote currency balance"),initialBaseBalance=(0,schema_1.baseNumberSchema)("Initial base currency balance"),initialQuoteBalance=(0,schema_1.baseNumberSchema)("Initial quote currency balance"),totalValueLocked=(0,schema_1.baseNumberSchema)("Total value locked in the pool"),unrealizedPnL=(0,schema_1.baseNumberSchema)("Unrealized profit/loss"),realizedPnL=(0,schema_1.baseNumberSchema)("Realized profit/loss"),lastRebalanceAt=(0,schema_1.baseDateTimeSchema)("Last rebalance timestamp");exports.aiMarketMakerPoolSchema={id:id,marketMakerId:(0,schema_1.baseStringSchema)("ID of the market maker"),baseCurrencyBalance:baseCurrencyBalance,quoteCurrencyBalance:quoteCurrencyBalance,initialBaseBalance:initialBaseBalance,initialQuoteBalance:initialQuoteBalance,totalValueLocked:totalValueLocked,unrealizedPnL:unrealizedPnL,realizedPnL:realizedPnL,lastRebalanceAt:lastRebalanceAt,createdAt:createdAt,updatedAt:updatedAt};exports.poolDepositSchema={type:"object",properties:{currency:(0,schema_1.baseEnumSchema)("Currency to deposit",["BASE","QUOTE"]),amount:(0,schema_1.baseNumberSchema)("Amount to deposit")},required:["currency","amount"]};exports.poolWithdrawSchema={type:"object",properties:{currency:(0,schema_1.baseEnumSchema)("Currency to withdraw",["BASE","QUOTE"]),amount:(0,schema_1.baseNumberSchema)("Amount to withdraw")},required:["currency","amount"]};const botId=(0,schema_1.baseStringSchema)("ID of the bot"),botName=(0,schema_1.baseStringSchema)("Name of the bot"),personality=(0,schema_1.baseEnumSchema)("Bot personality type",["SCALPER","SWING","ACCUMULATOR","DISTRIBUTOR","MARKET_MAKER"]),riskTolerance=(0,schema_1.baseNumberSchema)("Risk tolerance (0-1)"),tradeFrequency=(0,schema_1.baseEnumSchema)("Trade frequency",["HIGH","MEDIUM","LOW"]),avgOrderSize=(0,schema_1.baseNumberSchema)("Average order size"),orderSizeVariance=(0,schema_1.baseNumberSchema)("Order size variance (0-1)"),preferredSpread=(0,schema_1.baseNumberSchema)("Preferred spread"),botStatus=(0,schema_1.baseEnumSchema)("Bot status",["ACTIVE","PAUSED","COOLDOWN"]),lastTradeAt=(0,schema_1.baseDateTimeSchema)("Last trade timestamp"),dailyTradeCount=(0,schema_1.baseNumberSchema)("Daily trade count"),maxDailyTrades=(0,schema_1.baseNumberSchema)("Maximum daily trades");exports.aiBotSchema={id:botId,marketMakerId:(0,schema_1.baseStringSchema)("ID of the market maker"),name:botName,personality:personality,riskTolerance:riskTolerance,tradeFrequency:tradeFrequency,avgOrderSize:avgOrderSize,orderSizeVariance:orderSizeVariance,preferredSpread:preferredSpread,status:botStatus,lastTradeAt:lastTradeAt,dailyTradeCount:dailyTradeCount,maxDailyTrades:maxDailyTrades,createdAt:createdAt,updatedAt:updatedAt};exports.aiBotUpdateSchema={type:"object",properties:{riskTolerance:(0,schema_1.baseNumberSchema)("Risk tolerance (0-1)"),tradeFrequency:(0,schema_1.baseEnumSchema)("Trade frequency",["HIGH","MEDIUM","LOW"]),avgOrderSize:(0,schema_1.baseNumberSchema)("Average order size"),orderSizeVariance:(0,schema_1.baseNumberSchema)("Order size variance"),preferredSpread:(0,schema_1.baseNumberSchema)("Preferred spread"),maxDailyTrades:(0,schema_1.baseNumberSchema)("Maximum daily trades")}};const maxConcurrentBots=(0,schema_1.baseNumberSchema)("Maximum concurrent bots"),globalPauseEnabled=(0,schema_1.baseBooleanSchema)("Global pause enabled"),maintenanceMode=(0,schema_1.baseBooleanSchema)("Maintenance mode enabled"),minLiquidity=(0,schema_1.baseNumberSchema)("Minimum liquidity in quote currency"),maxDailyLossPercent=(0,schema_1.baseNumberSchema)("Maximum daily loss percentage"),defaultVolatilityThreshold=(0,schema_1.baseNumberSchema)("Default volatility threshold"),tradingEnabled=(0,schema_1.baseBooleanSchema)("Global trading enabled"),stopLossEnabled=(0,schema_1.baseBooleanSchema)("Stop loss protection enabled");exports.aiMarketMakerSettingsSchema={id:id,maxConcurrentBots:maxConcurrentBots,globalPauseEnabled:globalPauseEnabled,maintenanceMode:maintenanceMode,minLiquidity:minLiquidity,maxDailyLossPercent:maxDailyLossPercent,defaultVolatilityThreshold:defaultVolatilityThreshold,tradingEnabled:tradingEnabled,stopLossEnabled:stopLossEnabled,createdAt:createdAt,updatedAt:updatedAt};exports.aiMarketMakerSettingsUpdateSchema={type:"object",properties:{maxConcurrentBots:maxConcurrentBots,globalPauseEnabled:globalPauseEnabled,maintenanceMode:maintenanceMode,minLiquidity:minLiquidity,maxDailyLossPercent:maxDailyLossPercent,defaultVolatilityThreshold:defaultVolatilityThreshold,tradingEnabled:tradingEnabled,stopLossEnabled:stopLossEnabled}};const action=(0,schema_1.baseEnumSchema)("Action type",["TRADE","PAUSE","RESUME","REBALANCE","TARGET_CHANGE","DEPOSIT","WITHDRAW","START","STOP","CONFIG_CHANGE","EMERGENCY_STOP","AUTO_PAUSE"]),details={type:"object",description:"Action details"},priceAtAction=(0,schema_1.baseNumberSchema)("Price at the time of action"),poolValueAtAction=(0,schema_1.baseNumberSchema)("Pool value at the time of action");exports.aiMarketMakerHistorySchema={id:id,marketMakerId:(0,schema_1.baseStringSchema)("ID of the market maker"),action:action,details:details,priceAtAction:priceAtAction,poolValueAtAction:poolValueAtAction,createdAt:createdAt};exports.analyticsOverviewSchema={type:"object",properties:{totalTVL:(0,schema_1.baseNumberSchema)("Total value locked across all pools"),total24hVolume:(0,schema_1.baseNumberSchema)("Total 24-hour trading volume"),totalPnL:(0,schema_1.baseNumberSchema)("Total profit/loss"),activeMarkets:(0,schema_1.baseNumberSchema)("Number of active markets"),totalBots:(0,schema_1.baseNumberSchema)("Total number of bots"),activeBots:(0,schema_1.baseNumberSchema)("Number of active bots")}};exports.marketPerformanceSchema={type:"object",properties:{priceHistory:{type:"array",items:{type:"object",properties:{timestamp:(0,schema_1.baseDateTimeSchema)("Timestamp"),price:(0,schema_1.baseNumberSchema)("Price"),targetPrice:(0,schema_1.baseNumberSchema)("Target price")}}},volumeHistory:{type:"array",items:{type:"object",properties:{timestamp:(0,schema_1.baseDateTimeSchema)("Timestamp"),volume:(0,schema_1.baseNumberSchema)("Volume")}}},targetAchievementRate:(0,schema_1.baseNumberSchema)("Target achievement rate (0-100)")}};exports.pnlReportSchema={type:"object",properties:{daily:(0,schema_1.baseNumberSchema)("Daily P&L"),weekly:(0,schema_1.baseNumberSchema)("Weekly P&L"),monthly:(0,schema_1.baseNumberSchema)("Monthly P&L"),allTime:(0,schema_1.baseNumberSchema)("All-time P&L"),history:{type:"array",items:{type:"object",properties:{date:(0,schema_1.baseDateTimeSchema)("Date"),pnl:(0,schema_1.baseNumberSchema)("P&L for the day"),cumulativePnl:(0,schema_1.baseNumberSchema)("Cumulative P&L")}}}}};exports.aiMarketMakerStoreSchema={description:"AI Market Maker created or updated successfully",content:{"application/json":{schema:{type:"object",properties:exports.aiMarketMakerSchema}}}};exports.aiMarketMakerPoolStoreSchema={description:"AI Market Maker Pool updated successfully",content:{"application/json":{schema:{type:"object",properties:exports.aiMarketMakerPoolSchema}}}};exports.statusChangeSchema={type:"object",properties:{action:(0,schema_1.baseEnumSchema)("Status action",["START","PAUSE","STOP","RESUME"])},required:["action"]};exports.targetPriceUpdateSchema={type:"object",properties:{targetPrice:(0,schema_1.baseNumberSchema)("New target price")},required:["targetPrice"]};exports.biasUpdateSchema={type:"object",properties:{marketBias:(0,schema_1.baseEnumSchema)("Market bias direction",["BULLISH","BEARISH","NEUTRAL"]),biasStrength:(0,schema_1.baseNumberSchema)("Bias strength (0-100)")},required:["marketBias","biasStrength"]};exports.priceModeUpdateSchema={type:"object",properties:{priceMode:(0,schema_1.baseEnumSchema)("Price mode",["AUTONOMOUS","FOLLOW_EXTERNAL","HYBRID"]),externalSymbol:(0,schema_1.baseStringSchema)("External symbol to follow (e.g., BTC/USDT)"),correlationStrength:(0,schema_1.baseNumberSchema)("Correlation strength with external price (0-100)")},required:["priceMode"]};exports.volatilityConfigUpdateSchema={type:"object",properties:{baseVolatility:(0,schema_1.baseNumberSchema)("Base daily volatility percentage (e.g., 2.0 for 2%)"),volatilityMultiplier:(0,schema_1.baseNumberSchema)("Volatility multiplier (0.5-2.0)"),momentumDecay:(0,schema_1.baseNumberSchema)("Momentum decay rate (0.8-0.999)")}};exports.forcePhaseSchema={type:"object",properties:{targetPhase:(0,schema_1.baseEnumSchema)("Target phase to transition to",["ACCUMULATION","MARKUP","DISTRIBUTION","MARKDOWN"])},required:["targetPhase"]};exports.phaseStatusSchema={type:"object",properties:{currentPhase:(0,schema_1.baseEnumSchema)("Current market phase",["ACCUMULATION","MARKUP","DISTRIBUTION","MARKDOWN"]),phaseStartedAt:(0,schema_1.baseDateTimeSchema)("When the current phase started"),nextPhaseChangeAt:(0,schema_1.baseDateTimeSchema)("When the next phase change will occur"),phaseTargetPrice:(0,schema_1.baseNumberSchema)("Target price for the current phase"),progress:(0,schema_1.baseNumberSchema)("Progress through current phase (0-1)"),marketBias:(0,schema_1.baseEnumSchema)("Current market bias",["BULLISH","BEARISH","NEUTRAL"]),biasStrength:(0,schema_1.baseNumberSchema)("Current bias strength (0-100)"),trendMomentum:(0,schema_1.baseNumberSchema)("Current trend momentum (-1 to 1)")}};