"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.MomentumTracker=void 0;const DEFAULT_EVENT_CONFIG={eventProbability:5e-4,minMagnitude:.5,maxMagnitude:3},EVENT_PROBABILITIES={SURGE:.35,DUMP:.3,SPIKE:.25,FLASH_CRASH:.1};class MomentumTracker{constructor(t){this.states=new Map;this.eventConfig={...DEFAULT_EVENT_CONFIG,...t}}getState(t){this.states.has(t)||this.states.set(t,{momentum:0,lastUpdate:new Date,activeEvent:null,eventHistory:[],consecutiveDirection:0});return this.states.get(t)}getCurrentMomentum(t){return this.getState(t).momentum}updateMomentum(t,e,n,a=.95){const i=this.getState(t);i.momentum=this.applyDecay(i,a);const r="BUY"===e?1:-1,u=r*Math.min(.1*n,.1);i.momentum+=u;"BUY"===e&&i.consecutiveDirection>=0||"SELL"===e&&i.consecutiveDirection<=0?i.consecutiveDirection+=r:i.consecutiveDirection=r;Math.abs(i.consecutiveDirection)>5&&(i.momentum+=.02*r);i.momentum=Math.max(-1,Math.min(1,i.momentum));i.lastUpdate=new Date;return i.momentum}decayMomentum(t,e,n){const a=this.getState(t);a.momentum=this.applyDecay(a,e,n);a.lastUpdate=new Date;return a.momentum}applyDecay(t,e,n){const a=(null!=n?n:Date.now()-t.lastUpdate.getTime())/1e3;return t.momentum*Math.pow(e,a)}checkForMomentumEvent(t,e){const n=this.getState(t),a={...this.eventConfig,...e};if(n.activeEvent){if(Date.now()-n.activeEvent.startedAt.getTime()<n.activeEvent.duration)return this.getDecayedEvent(n.activeEvent);n.activeEvent=null}if(Math.random()<a.eventProbability){const t=this.generateEvent(a);n.activeEvent=t;n.eventHistory.push({type:t.type,magnitude:t.magnitude,timestamp:new Date});n.eventHistory.length>20&&n.eventHistory.shift();return t}return null}getActiveEvent(t){const e=this.getState(t);if(!e.activeEvent)return null;if(Date.now()-e.activeEvent.startedAt.getTime()>=e.activeEvent.duration){e.activeEvent=null;return null}return this.getDecayedEvent(e.activeEvent)}getDecayedEvent(t){const e=(Date.now()-t.startedAt.getTime())/t.duration,n=Math.pow(t.decayRate,10*e);return{...t,magnitude:t.magnitude*n}}generateEvent(t){const e=this.selectEventType(),n=this.getEventConfig(e);return{type:e,magnitude:(t.minMagnitude+Math.random()*(t.maxMagnitude-t.minMagnitude))*n.magnitudeMultiplier,duration:n.duration,decayRate:n.decayRate,startedAt:new Date}}selectEventType(){const t=Math.random();let e=0;for(const[n,a]of Object.entries(EVENT_PROBABILITIES)){e+=a;if(t<=e)return n}return"SURGE"}getEventConfig(t){switch(t){case"SURGE":return{magnitudeMultiplier:.5,duration:3e5,decayRate:.85};case"DUMP":return{magnitudeMultiplier:-.6,duration:24e4,decayRate:.8};case"SPIKE":return{magnitudeMultiplier:Math.random()>.5?.7:-.7,duration:6e4,decayRate:.7};case"FLASH_CRASH":return{magnitudeMultiplier:-.8,duration:3e4,decayRate:.6}}}triggerEvent(t,e,n,a){const i=this.getState(t),r=this.getEventConfig(e),u={type:e,magnitude:n,duration:null!=a?a:r.duration,decayRate:r.decayRate,startedAt:new Date};i.activeEvent=u;i.eventHistory.push({type:u.type,magnitude:u.magnitude,timestamp:new Date});return u}clearEvent(t){this.getState(t).activeEvent=null}setMomentum(t,e,n){const a=this.getState(t);a.momentum=Math.max(-1,Math.min(1,e));a.lastUpdate=null!=n?n:new Date}getEventHistory(t){return[...this.getState(t).eventHistory]}getFullState(t){return{...this.getState(t)}}resetState(t){this.states.delete(t)}updateConfig(t){this.eventConfig={...this.eventConfig,...t}}}exports.MomentumTracker=MomentumTracker;exports.default=MomentumTracker;