"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.MarketMakerEngine=void 0;const db_1=require("@b/db"),redis_1=require("@b/utils/redis"),console_1=require("@b/utils/console"),client_1=require("../scylla/client"),MarketManager_1=require("./MarketManager"),StrategyManager_1=require("./strategies/StrategyManager"),RiskManager_1=require("./risk/RiskManager"),PoolManager_1=require("./pool/PoolManager"),cache_1=require("@b/utils/cache"),redis=redis_1.RedisSingleton.getInstance(),DEFAULT_CONFIG={tickIntervalMs:1e3,maxConcurrentMarkets:10,enableRealLiquidity:!0,emergencyStopEnabled:!0};class MarketMakerEngine{constructor(){this.status="STOPPED";this.config=DEFAULT_CONFIG;this.tickInterval=null;this.lastTickTime=null;this.tickCount=0;this.errorCount=0;this.startTime=null;this.marketManager=null;this.strategyManager=null;this.riskManager=null;this.poolManager=null;this.tickInProgress=!1;this.consecutiveSlowTicks=0;this.MAX_TICK_DURATION_MS=5e3}static getInstance(){MarketMakerEngine.instance||(MarketMakerEngine.instance=new MarketMakerEngine);return MarketMakerEngine.instance}async initialize(t){if("STOPPED"===this.status){this.status="STARTING";try{this.config={...DEFAULT_CONFIG,...t};await(0,client_1.initializeAiMarketMakerTables)();await this.loadGlobalSettings();this.marketManager=new MarketManager_1.MarketManager(this);this.strategyManager=new StrategyManager_1.StrategyManager;this.riskManager=new RiskManager_1.RiskManager(this);this.poolManager=new PoolManager_1.PoolManager;await this.marketManager.loadActiveMarkets();this.status="RUNNING";this.startTime=new Date;this.errorCount=0;this.startTickLoop();await this.publishStatus()}catch(t){this.status="ERROR";console_1.logger.error("AI_MM","Failed to initialize engine",t);throw t}}}async shutdown(){if("STOPPED"!==this.status){this.status="STOPPING";console_1.logger.warn("AI_MM","Shutting down Market Maker Engine...");try{this.stopTickLoop();this.marketManager&&await this.marketManager.stopAllMarkets();this.marketManager=null;this.strategyManager=null;this.riskManager=null;this.poolManager=null;this.status="STOPPED";this.startTime=null;console_1.logger.success("AI_MM","Market Maker Engine shut down successfully");await this.publishStatus()}catch(t){this.status="ERROR";console_1.logger.error("AI_MM","Failed to shutdown Market Maker Engine",t);throw t}}else console_1.logger.warn("AI_MM","Engine is already stopped")}async emergencyStop(){console_1.logger.error("AI_MM","EMERGENCY STOP TRIGGERED");this.stopTickLoop();this.marketManager&&await this.marketManager.emergencyStopAllMarkets();this.status="STOPPED";await this.logHistory("EMERGENCY_STOP",{reason:"Manual emergency stop triggered",timestamp:(new Date).toISOString()});await this.publishStatus()}getStatus(){var t;return{status:this.status,uptime:this.startTime?Date.now()-this.startTime.getTime():null,tickCount:this.tickCount,errorCount:this.errorCount,activeMarkets:(null===(t=this.marketManager)||void 0===t?void 0:t.getActiveMarketCount())||0,config:this.config}}getMarketManager(){return this.marketManager}getStrategyManager(){return this.strategyManager}getRiskManager(){return this.riskManager}getPoolManager(){return this.poolManager}getConfig(){return{...this.config}}updateConfig(t){this.config={...this.config,...t};console_1.logger.info("AI_MM",`Configuration updated: ${JSON.stringify(this.config)}`)}async loadGlobalSettings(){try{const t=cache_1.CacheManager.getInstance(),[e,a,i,r]=await Promise.all([t.getSetting("aiMarketMakerMaxConcurrentBots"),t.getSetting("aiMarketMakerEnabled"),t.getSetting("aiMarketMakerMaintenanceMode"),t.getSetting("aiMarketMakerGlobalPauseEnabled")]);this.config.maxConcurrentMarkets=e||50;this.config.enableRealLiquidity=!1!==a;(i||r)&&console_1.logger.warn("AI_MM","Global pause or maintenance mode is enabled")}catch(t){console_1.logger.error("AI_MM","Failed to load global settings",t)}}startTickLoop(){this.tickInterval||(this.tickInterval=setInterval(async()=>{await this.tick()},this.config.tickIntervalMs))}stopTickLoop(){if(this.tickInterval){clearInterval(this.tickInterval);this.tickInterval=null;console_1.logger.info("AI_MM","Tick loop stopped")}}async tick(){var t;if("RUNNING"!==this.status)return;if(this.tickInProgress){this.consecutiveSlowTicks++;this.consecutiveSlowTicks>10&&console_1.logger.warn("AI_MM",`Warning: ${this.consecutiveSlowTicks} consecutive slow ticks detected`);return}this.tickInProgress=!0;const e=Date.now();this.tickCount++;this.lastTickTime=new Date;"development"===process.env.NODE_ENV&&this.tickCount%30==0&&console_1.logger.debug("AI_MM",`Tick #${this.tickCount} | Markets: ${(null===(t=this.marketManager)||void 0===t?void 0:t.getActiveMarketCount())||0} | Errors: ${this.errorCount}`);try{if(this.riskManager){const t=await this.riskManager.checkGlobalRisk();if(!t.canTrade){this.tickCount%60==0&&console_1.logger.warn("AI_MM",`Trading paused: ${t.reason}`);return}}if(this.marketManager){const t=this.marketManager.processAllMarkets(),e=new Promise((t,e)=>setTimeout(()=>e(new Error("Market processing timeout")),this.MAX_TICK_DURATION_MS));await Promise.race([t,e])}this.tickCount%60==0&&await this.performPeriodicTasks();this.consecutiveSlowTicks=0}catch(t){this.errorCount++;"Market processing timeout"===(null==t?void 0:t.message)?console_1.logger.error("AI_MM",`Tick timeout - processing took > ${this.MAX_TICK_DURATION_MS}ms`):console_1.logger.error("AI_MM","Tick processing error",t);this.errorCount>100&&this.config.emergencyStopEnabled&&await this.emergencyStop()}finally{this.tickInProgress=!1;const t=Date.now()-e;t>2*this.config.tickIntervalMs&&console_1.logger.warn("AI_MM",`Slow tick detected: ${t}ms (expected < ${this.config.tickIntervalMs}ms)`)}}async performPeriodicTasks(){await this.checkDailyVolumeReset();this.poolManager&&await this.poolManager.updateAllBalances();this.marketManager&&await this.marketManager.cleanupExpiredOrders();await this.publishStatus()}async checkDailyVolumeReset(){try{const t=new Date,e="ai_market_maker:last_daily_reset",a=await redis.get(e),i=a?new Date(a):null,r=t.toISOString().split("T")[0];if((null==i?void 0:i.toISOString().split("T")[0])!==r){console_1.logger.info("AI_MM","Performing daily volume reset...");await db_1.models.aiMarketMaker.update({currentDailyVolume:0},{where:{}});await db_1.models.aiBot.update({dailyTradeCount:0},{where:{}});this.marketManager&&await this.marketManager.refreshAllMarkets();await redis.set(e,t.toISOString());console_1.logger.info("AI_MM","Daily volume reset complete");await this.logHistory("DAILY_RESET",{resetDate:r,timestamp:t.toISOString()})}}catch(t){console_1.logger.error("AI_MM","Failed to check daily volume reset",t)}}async publishStatus(){try{const t=this.getStatus();await redis.set("ai_market_maker:engine:status",JSON.stringify(t),"EX",60)}catch(t){}}async logHistory(t,e){try{console_1.logger.info("AI_MM",`History: ${t} - ${JSON.stringify(e)}`)}catch(t){}}}exports.MarketMakerEngine=MarketMakerEngine;exports.default=MarketMakerEngine.getInstance();