"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var a=Object.getOwnPropertyDescriptor(t,i);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[i]}});Object.defineProperty(e,r,a)}:function(e,t,i,r){void 0===r&&(r=i);e[r]=t[i]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var i={};if(null!=t)for(var r=e(t),a=0;a<r.length;a++)"default"!==r[a]&&__createBinding(i,t,r[a]);__setModuleDefault(i,t);return i}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.MarketInstance=void 0;const console_1=require("@b/utils/console"),PriceTracker_1=require("./PriceTracker"),OrderManager_1=require("./OrderManager"),TradeExecutor_1=require("./TradeExecutor"),queries_1=require("../scylla/queries"),volatility_1=require("./volatility"),trend_1=require("./trend"),external_1=require("./external");class MarketInstance{constructor(e,t){this.status="INITIALIZING";this.currentPrice=BigInt(0);this.simulatedPrice=BigInt(0);this.lastProcessTime=null;this.processCount=0;this.errorCount=0;this.dailyVolumeLimitLogged=!1;this.phaseInitialized=!1;this.recentPriceChanges=[];this.MAX_CUMULATIVE_CHANGE_PERCENT=3;this.PRICE_CHANGE_WINDOW_MS=6e4;this.engine=e;this.config=this.parseConfig(t);this.priceTracker=new PriceTracker_1.PriceTracker(this.config.symbol,this.config.marketId);this.orderManager=new OrderManager_1.OrderManager(this.config,e);this.tradeExecutor=new TradeExecutor_1.TradeExecutor(this.config,this.orderManager);this.volatilityEngine=new volatility_1.VolatilityEngine;this.momentumTracker=new volatility_1.MomentumTracker;this.trendManager=new trend_1.TrendManager;this.externalPriceSync=new external_1.ExternalPriceSync;(0!==this.config.trendMomentum||this.config.lastMomentumUpdate)&&this.momentumTracker.setMomentum(this.config.id,this.config.trendMomentum,this.config.lastMomentumUpdate||void 0)}parseConfig(e){var t;const i=e.market?`${e.market.currency}/${e.market.pair}`:"UNKNOWN/UNKNOWN";return{id:e.id,marketId:e.marketId,symbol:i,status:e.status,targetPrice:parseFloat(e.targetPrice)||0,priceRangeLow:parseFloat(e.priceRangeLow)||0,priceRangeHigh:parseFloat(e.priceRangeHigh)||0,aggressionLevel:e.aggressionLevel||"CONSERVATIVE",maxDailyVolume:parseFloat(e.maxDailyVolume)||0,currentDailyVolume:parseFloat(e.currentDailyVolume)||0,volatilityThreshold:parseFloat(e.volatilityThreshold)||5,pauseOnHighVolatility:null===(t=e.pauseOnHighVolatility)||void 0===t||t,realLiquidityPercent:parseFloat(e.realLiquidityPercent)||0,pool:e.pool?{baseCurrencyBalance:parseFloat(e.pool.baseCurrencyBalance)||0,quoteCurrencyBalance:parseFloat(e.pool.quoteCurrencyBalance)||0,totalValueLocked:parseFloat(e.pool.totalValueLocked)||0}:null,bots:(e.bots||[]).map(e=>({id:e.id,name:e.name,personality:e.personality,riskTolerance:parseFloat(e.riskTolerance)||.5,tradeFrequency:e.tradeFrequency||"MEDIUM",avgOrderSize:parseFloat(e.avgOrderSize)||0,orderSizeVariance:parseFloat(e.orderSizeVariance)||.2,preferredSpread:parseFloat(e.preferredSpread)||.001,status:e.status,lastTradeAt:e.lastTradeAt,dailyTradeCount:e.dailyTradeCount||0,maxDailyTrades:e.maxDailyTrades||100})),priceMode:e.priceMode||"AUTONOMOUS",externalSymbol:e.externalSymbol||null,correlationStrength:parseFloat(e.correlationStrength)||50,marketBias:e.marketBias||"NEUTRAL",biasStrength:parseFloat(e.biasStrength)||50,currentPhase:e.currentPhase||"ACCUMULATION",phaseStartedAt:e.phaseStartedAt?new Date(e.phaseStartedAt):null,nextPhaseChangeAt:e.nextPhaseChangeAt?new Date(e.nextPhaseChangeAt):null,phaseTargetPrice:e.phaseTargetPrice?parseFloat(e.phaseTargetPrice):null,baseVolatility:parseFloat(e.baseVolatility)||2,volatilityMultiplier:parseFloat(e.volatilityMultiplier)||1,momentumDecay:parseFloat(e.momentumDecay)||.95,lastKnownPrice:e.lastKnownPrice?parseFloat(e.lastKnownPrice):null,trendMomentum:parseFloat(e.trendMomentum)||0,lastMomentumUpdate:e.lastMomentumUpdate?new Date(e.lastMomentumUpdate):null}}async initialize(){try{await this.priceTracker.initialize();const e=await(0,queries_1.getLastCandleClosePrice)(this.config.symbol);if(null!==e&&e>0){this.currentPrice=BigInt(Math.floor(1e18*e));this.simulatedPrice=this.currentPrice;console_1.logger.info("AI_MM",`Using last candle close price for ${this.config.symbol}: ${e}`)}else{this.currentPrice=await this.priceTracker.getCurrentPrice();if(this.currentPrice===BigInt(0)&&this.config.targetPrice>0){this.currentPrice=BigInt(Math.floor(1e18*this.config.targetPrice));console_1.logger.info("AI_MM",`No external price for ${this.config.symbol}, using target price: ${this.config.targetPrice}`)}this.simulatedPrice=this.currentPrice}await(0,queries_1.clearOrderbookForSymbol)(this.config.symbol);const t=await(0,queries_1.deleteAiBotOrdersByMarket)(this.config.marketId);t>0&&console_1.logger.debug("AI_MM",`Cleaned up ${t} old AI bot orders for ${this.config.symbol}`);await this.orderManager.initialize();await this.seedOrderbook();this.status="RUNNING";console_1.logger.success("AI_MM",`Market instance initialized: ${this.config.symbol}`)}catch(e){this.status="ERROR";console_1.logger.error("AI_MM","Market instance initialization error",e);throw e}}async seedOrderbook(){try{const e=this.config.bots.filter(e=>"ACTIVE"===e.status);if(0===e.length){console_1.logger.warn("AI_MM",`No active bots for ${this.config.symbol}, cannot seed orderbook`);return}const t=this.config.targetPrice;if(t<=0){console_1.logger.warn("AI_MM",`No target price for ${this.config.symbol}, cannot seed orderbook`);return}console_1.logger.debug("AI_MM",`Seeding orderbook for ${this.config.symbol} around target price ${t}`);let i=e.reduce((e,t)=>e+t.avgOrderSize,0)/e.length;i<=0&&(i=Math.max(.1,100/t));if(this.config.pool&&this.config.pool.baseCurrencyBalance>0){const e=.1*this.config.pool.baseCurrencyBalance;i=Math.min(i,e)}await(0,queries_1.syncOrderbookFromAiTrade)(this.config.symbol,t,i,"BUY");await(0,queries_1.syncCandlesFromAiTrade)(this.config.symbol,t,i);console_1.logger.success("AI_MM",`Seeded orderbook and candles for ${this.config.symbol} at ${t}`)}catch(e){console_1.logger.error("AI_MM","Orderbook seeding error",e);console_1.logger.warn("AI_MM",`Failed to seed orderbook for ${this.config.symbol}, continuing anyway`)}}async shutdown(){this.status="STOPPED";await this.cancelAllOrders();this.priceTracker.cleanup()}async emergencyStop(){this.status="STOPPED";await this.orderManager.cancelAllOrders()}async pause(){this.status="PAUSED"}async resume(){this.status="RUNNING"}async setTargetPrice(e,t){const{persist:i=!0,source:r="EXTERNAL",updatePhaseTarget:a=!1}=t||{};if(e<=0||!isFinite(e)){console_1.logger.warn("AI_MM",`Invalid target price ${e} for ${this.config.symbol}, ignoring`);return}const o=this.config.priceRangeLow,n=this.config.priceRangeHigh;o>0&&n>0&&(e=Math.max(o,Math.min(n,e)));const s=this.config.targetPrice;this.config.targetPrice=e;a&&(this.config.phaseTargetPrice=e);console_1.logger.debug("AI_MM",`Target price updated for ${this.config.symbol}: ${s} -> ${e} (source: ${r})`);if(i)try{const{models:t}=await Promise.resolve().then(()=>__importStar(require("@b/db"))),i={targetPrice:e};a&&(i.phaseTargetPrice=e);await t.aiMarketMaker.update(i,{where:{id:this.config.id}})}catch(e){console_1.logger.error("AI_MM",`Failed to persist target price for ${this.config.symbol}`,e)}}updateConfig(e){const t=this.parseConfig(e);this.config=t;console_1.logger.info("AI_MM",`Config updated for ${this.config.symbol}: dailyVolume=${this.config.currentDailyVolume}/${this.config.maxDailyVolume}`)}async cancelAllOrders(){await this.orderManager.cancelAllOrders()}async cleanupExpiredOrders(){await this.orderManager.cleanupExpiredOrders()}async process(){if("RUNNING"===this.status){this.processCount++;this.lastProcessTime=new Date;try{await this.updatePrice();if(!this.shouldTrade())return;const e=await this.getStrategyDecision();e.shouldAct&&await this.executeDecision(e);await this.recordPriceHistory()}catch(e){this.errorCount++;console_1.logger.error("AI_MM",`Process error for ${this.config.symbol}`,e);if(this.errorCount>10){this.status="PAUSED";console_1.logger.error("AI_MM",`Too many errors, pausing ${this.config.symbol}`)}}}}async updatePrice(){const e=await this.priceTracker.fetchExternalPrice();e>BigInt(0)&&(this.currentPrice=e)}shouldTrade(){const e=this.config.bots.filter(e=>"ACTIVE"===e.status);if(e.length<2){this.processCount%60==0&&console_1.logger.warn("AI_MM",`Need at least 2 active bots for ${this.config.symbol}, have: ${e.length}`);return!1}if(this.config.realLiquidityPercent>0&&(!this.config.pool||this.config.pool.totalValueLocked<=0)){this.processCount%60==0&&console_1.logger.warn("AI_MM",`Real liquidity enabled but no pool for ${this.config.symbol}`);return!1}if(this.config.maxDailyVolume>0&&this.config.currentDailyVolume>=this.config.maxDailyVolume){if(!this.dailyVolumeLimitLogged){console_1.logger.warn("AI_MM",`Daily volume limit reached for ${this.config.symbol}: ${this.config.currentDailyVolume}/${this.config.maxDailyVolume}`);this.dailyVolumeLimitLogged=!0}return!1}this.dailyVolumeLimitLogged=!1;if(this.config.pauseOnHighVolatility){const e=this.priceTracker.getVolatility();if(e>this.config.volatilityThreshold){console_1.logger.warn("AI_MM",`High volatility (${e}%), skipping ${this.config.symbol}`);return!1}}const t=this.getTradeChance(),i=Math.random(),r=i<t;"development"===process.env.NODE_ENV&&this.processCount%10==0&&console_1.logger.debug("AI_MM",`${this.config.symbol} tick #${this.processCount}: chance=${(100*t).toFixed(0)}%, roll=${(100*i).toFixed(0)}%, trade=${r}`);return r}getTradeChance(){switch(this.config.aggressionLevel){case"AGGRESSIVE":return.3;case"MODERATE":return.15;default:return.05}}async getStrategyDecision(){const e=Number(this.simulatedPrice)/1e18,t=this.config.priceRangeLow||.5*this.config.targetPrice,i=this.config.priceRangeHigh||2*this.config.targetPrice;this.phaseInitialized||this.config.phaseStartedAt||await this.initializePhase(e);this.phaseInitialized=!0;this.trendManager.shouldTransitionPhase(this.config.nextPhaseChangeAt)&&await this.executePhaseTransition(e);const r=this.trendManager.getPhaseContext(this.config.currentPhase,this.config.lastKnownPrice||e,this.config.phaseTargetPrice||this.config.targetPrice,this.config.phaseStartedAt,this.config.nextPhaseChangeAt);let a;if("AUTONOMOUS"!==this.config.priceMode&&this.config.externalSymbol){const t=await this.externalPriceSync.getGravityAdjustedTarget(e,this.config.externalSymbol,this.config.correlationStrength);t&&(a={price:t.externalPrice,strength:"FOLLOW_EXTERNAL"===this.config.priceMode?this.config.correlationStrength/100:this.config.correlationStrength/100*.5})}const o=this.momentumTracker.getCurrentMomentum(this.config.id),n=this.volatilityEngine.calculatePriceMovement(this.config.id,e,{baseVolatility:this.config.baseVolatility,volatilityMultiplier:this.config.volatilityMultiplier,momentumDecay:this.config.momentumDecay},r,o,a),s=this.momentumTracker.checkForMomentumEvent(this.config.id,{eventProbability:5e-4,minMagnitude:.5*this.config.baseVolatility,maxMagnitude:2*this.config.baseVolatility});let c=n.newPrice;if(s){c*=1+s.magnitude/100;console_1.logger.debug("AI_MM",`Momentum event for ${this.config.symbol}: ${s.type} | magnitude: ${s.magnitude.toFixed(2)}%`);this.logMomentumEvent(s)}if(e>0){const t=1.005*e,i=.995*e;c=Math.max(i,Math.min(t,c))}const l=(c-e)/e*100;c=this.applyCumulativePriceLimit(c,e,l);c=Math.max(t,Math.min(i,c));this.simulatedPrice=BigInt(Math.floor(1e18*c));const h=(c-e)/e*100;this.trackPriceChange(h);this.momentumTracker.updateMomentum(this.config.id,n.direction,Math.abs(n.percentChange),this.config.momentumDecay);this.processCount%30==0&&console_1.logger.debug("AI_MM",`${this.config.symbol}: ${n.direction} | price: ${c.toFixed(6)} | phase: ${this.config.currentPhase} | momentum: ${n.momentum.toFixed(3)}`);return{shouldAct:!0,direction:n.direction,targetPrice:c,orderSize:this.calculateOrderSize()}}trackPriceChange(e){const t=Date.now();this.recentPriceChanges.push({timestamp:t,changePercent:e});const i=t-this.PRICE_CHANGE_WINDOW_MS;this.recentPriceChanges=this.recentPriceChanges.filter(e=>e.timestamp>=i)}applyCumulativePriceLimit(e,t,i){const r=Date.now()-this.PRICE_CHANGE_WINDOW_MS;let a=0;for(const e of this.recentPriceChanges)e.timestamp>=r&&(e.changePercent>0&&i>0||e.changePercent<0&&i<0)&&(a+=Math.abs(e.changePercent));const o=Math.max(0,this.MAX_CUMULATIVE_CHANGE_PERCENT-a),n=Math.abs(i);if(n>o){const e=o/n,r=t*(1+i*e/100);this.processCount%60==0&&e<1&&console_1.logger.debug("AI_MM",`${this.config.symbol}: Price change limited by cumulative cap (${a.toFixed(2)}% in window, proposed ${i.toFixed(2)}%)`);return r}return e}async initializePhase(e){try{const t=await this.trendManager.initializePhase(this.config.id,e,this.config.marketBias,this.config.biasStrength);this.config.currentPhase=t.phase;this.config.phaseStartedAt=t.phaseStartedAt;this.config.nextPhaseChangeAt=t.nextPhaseChangeAt;this.config.phaseTargetPrice=t.phaseTargetPrice;this.config.lastKnownPrice=e;console_1.logger.info("AI_MM",`Initialized phase for ${this.config.symbol}: ${t.phase} | target: ${t.phaseTargetPrice.toFixed(6)}`)}catch(e){console_1.logger.error("AI_MM",`Failed to initialize phase for ${this.config.symbol}`,e)}}async executePhaseTransition(e){try{const t=await this.trendManager.executePhaseTransition(this.config.id,e,this.config.currentPhase,this.config.marketBias,this.config.biasStrength);this.config.currentPhase=t.newPhase;this.config.phaseStartedAt=t.phaseStartedAt;this.config.nextPhaseChangeAt=t.nextPhaseChangeAt;this.config.phaseTargetPrice=t.phaseTargetPrice;this.config.volatilityMultiplier=this.trendManager.getVolatilityMultiplier(t.newPhase);this.config.lastKnownPrice=e;console_1.logger.info("AI_MM",`Phase transition for ${this.config.symbol}: -> ${t.newPhase} | duration: ${t.durationHours}h | target: ${t.phaseTargetPrice.toFixed(6)}`)}catch(e){console_1.logger.error("AI_MM",`Failed to execute phase transition for ${this.config.symbol}`,e)}}async logMomentumEvent(e){var t;try{const{models:i}=await Promise.resolve().then(()=>__importStar(require("@b/db")));await i.aiMarketMakerHistory.create({marketMakerId:this.config.id,action:"MOMENTUM_EVENT",details:{eventType:e.type,magnitude:e.magnitude,eventDuration:e.duration/1e3,triggeredBy:"SYSTEM"},priceAtAction:Number(this.simulatedPrice)/1e18,poolValueAtAction:(null===(t=this.config.pool)||void 0===t?void 0:t.totalValueLocked)||0})}catch(e){console_1.logger.debug("AI_MM","Failed to log momentum event",e)}}calculateStepSize(e){const t=Math.abs(e);let i;switch(this.config.aggressionLevel){case"AGGRESSIVE":i=.5;break;case"MODERATE":i=.2;break;default:i=.1}return Math.min(.1*t,i)*(.8+.4*Math.random())}calculateOrderSize(){const e=this.config.bots.filter(e=>"ACTIVE"===e.status);if(0===e.length)return BigInt(0);const t=e[Math.floor(Math.random()*e.length)],i=Math.min(t.orderSizeVariance,.5),r=1-i+Math.random()*i*2;let a=t.avgOrderSize*r;if(this.config.pool&&this.config.pool.baseCurrencyBalance>0){const e=this.config.pool.baseCurrencyBalance*(.05+.1*Math.random());a>e&&this.config.realLiquidityPercent>0&&(a=e)}const o=.001;a<o&&(a=o);if(a<o){const e=this.config.targetPrice||1;a=Math.max(.01,10/e)}return BigInt(Math.floor(1e18*a))}async executeDecision(e){if(!(e.shouldAct&&e.direction&&e.orderSize&&e.targetPrice))return;const{aiAmount:t,realAmount:i}=(0,queries_1.calculateLiquiditySplit)(e.orderSize,this.config.realLiquidityPercent);t>BigInt(0)&&await this.tradeExecutor.executeAiTrade({direction:e.direction,amount:t,targetPrice:e.targetPrice});i>BigInt(0)&&await this.tradeExecutor.placeRealLiquidityOrder({direction:e.direction,amount:i,targetPrice:e.targetPrice,volatility:this.priceTracker.getVolatility()})}async recordPriceHistory(){if(this.processCount%10==0)try{await(0,queries_1.insertPriceHistory)({marketId:this.config.marketId,price:this.currentPrice,volume:BigInt(0),isAiTrade:!0,source:"AI"})}catch(e){}}getStatus(){return this.status}getConfig(){return{...this.config}}getCurrentPrice(){return this.currentPrice}getSymbol(){return this.config.symbol}getStats(){return{processCount:this.processCount,errorCount:this.errorCount,lastProcessTime:this.lastProcessTime,currentPrice:(Number(this.currentPrice)/1e18).toFixed(8)}}}exports.MarketInstance=MarketInstance;exports.default=MarketInstance;