"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.TimingGenerator=void 0;class TimingGenerator{constructor(t=1e3,s=1e4){this.lastActionTime=0;this.actionsInBurst=0;this.burstStartTime=0;this.sessionStartTime=Date.now();this.burstThreshold=5;this.burstCooldownMs=3e4;this.fatigueOnsetMs=36e5;this.baseDelayMs=t;this.maxDelayMs=s;this.sessionStartTime=Date.now()}getNextDelay(){const t=Date.now();let s=this.generateGaussianDelay();s*=this.getTimeOfDayModifier();s*=this.getBurstModifier(t);s*=this.getFatigueModifier();s*=.8+.4*Math.random();s=Math.max(this.baseDelayMs,Math.min(this.maxDelayMs,s));this.lastActionTime=t;this.updateBurstState(t);return Math.floor(s)}getDelayForAction(t){const s=this.getNextDelay();return Math.floor(s*({PLACE_ORDER:1,CANCEL_ORDER:.5,CHECK_MARKET:.3,MODIFY_ORDER:1.2}[t]||1))}isGoodTimeToTrade(){if(this.getTimeOfDayModifier()<.3)return Math.random()<.1;if(this.actionsInBurst>=this.burstThreshold){if(Date.now()-this.burstStartTime<this.burstCooldownMs)return Math.random()<.2}return!0}getActionProbability(){const t=Date.now()-this.lastActionTime,s=2*this.baseDelayMs;return 1/(1+Math.exp(-(t-s)/s))*this.getTimeOfDayModifier()*(1/this.getFatigueModifier())}getThinkingTime(t){const s={SIMPLE:500,NORMAL:2e3,COMPLEX:5e3}[t]*(.5+Math.random()),e=Math.random()<.1?3e3*Math.random():0;return Math.floor(s+e)}resetSession(){this.sessionStartTime=Date.now();this.actionsInBurst=0;this.burstStartTime=0}generateGaussianDelay(){const t=Math.random(),s=Math.random(),e=Math.sqrt(-2*Math.log(t))*Math.cos(2*Math.PI*s),i=2*this.baseDelayMs,a=this.baseDelayMs;return Math.abs(i+e*a)}getTimeOfDayModifier(){return{0:.3,1:.2,2:.2,3:.2,4:.3,5:.4,6:.5,7:.6,8:.7,9:.8,10:.9,11:.9,12:.8,13:1,14:1,15:1,16:.9,17:.8,18:.7,19:.6,20:.5,21:.4,22:.4,23:.3}[(new Date).getUTCHours()]||.5}getBurstModifier(t){if(this.actionsInBurst>=this.burstThreshold){if(t-this.burstStartTime<this.burstCooldownMs)return 3+2*Math.random();this.actionsInBurst=0}return 1}updateBurstState(t){if(t-this.lastActionTime<3*this.baseDelayMs){0===this.actionsInBurst&&(this.burstStartTime=t);this.actionsInBurst++}else{this.actionsInBurst=1;this.burstStartTime=t}}getFatigueModifier(){const t=Date.now()-this.sessionStartTime;if(t<this.fatigueOnsetMs)return 1;const s=(t-this.fatigueOnsetMs)/36e5;return 1+Math.min(1,.33*s)}getStats(){return{sessionDurationMs:Date.now()-this.sessionStartTime,actionsInBurst:this.actionsInBurst,lastActionAgo:Date.now()-this.lastActionTime,currentModifier:this.getTimeOfDayModifier()*this.getBurstModifier(Date.now())*this.getFatigueModifier()}}}exports.TimingGenerator=TimingGenerator;exports.default=TimingGenerator;