"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Bulk deletes AI Investments by IDs",operationId:"bulkDeleteAIInvestments",tags:["Admin","AI Investment"],parameters:(0,query_1.commonBulkDeleteParams)("AI Investments"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of AI Investment IDs to delete"}},required:["ids"]}}}},responses:(0,query_1.commonBulkDeleteResponses)("AI Investments"),requiresAuth:!0,permission:"delete.ai.investment",logModule:"ADMIN_AI",logTitle:"Bulk delete AI investments"};exports.default=async e=>{const{body:t,query:n,ctx:s}=e,{ids:l}=t,r=await(0,query_1.handleBulkDelete)({model:"aiInvestment",ids:l,query:{...n,force:!0,restore:void 0},preDelete:async()=>{null==s||s.step(`Processing ${l.length} investment(s) for deletion`);for(const e of l){const t=await db_1.models.transaction.findOne({where:{referenceId:e},include:[{model:db_1.models.wallet,as:"wallet"}]});t?t.wallet?await wallet_1.walletService.credit({idempotencyKey:`admin_ai_investment_bulk_delete_refund_${e}`,userId:t.wallet.userId,walletId:t.wallet.id,walletType:t.wallet.type,currency:t.wallet.currency,amount:t.amount,operationType:"REFUND",description:`Refund for deleted AI Investment ${e}`}):null==s||s.warn(`Wallet not found for transaction: ${t.id}`):null==s||s.warn(`Transaction not found for id: ${e}`)}null==s||s.step("Wallet balances updated")},postDelete:async()=>{null==s||s.step("Cleaning up transaction records");for(const e of l)await db_1.models.transaction.destroy({where:{referenceId:e}})}});null==s||s.success(`Deleted ${l.length} investment(s)`);return r};