"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Get AI investment duration options",operationId:"getAiInvestmentDurationOptions",tags:["Admin","AI Investment","Duration"],description:"Retrieves all available AI investment durations formatted as selectable options. Returns simplified data structure with ID and formatted name for dropdown/select use.",requiresAuth:!0,logModule:"ADMIN_AI",logTitle:"Get AI Investment Duration Options",responses:{200:{description:"AI investment duration options retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",format:"uuid",description:"Unique identifier of the duration"},name:{type:"string",description:"Formatted duration name (e.g., '30 DAY', '1 MONTH')"}},required:["id","name"]}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("AI Investment Duration"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)(401,"Unauthorized");try{null==r||r.step("Get AI Investment Duration Options");const e=(await db_1.models.aiInvestmentDuration.findAll()).map(e=>({id:e.id,name:`${e.duration} ${e.timeframe}`}));null==r||r.success("Get AI Investment Duration Options retrieved successfully");return e}catch(e){throw(0,error_1.createError)(500,"An error occurred while fetching AI investment durations")}};