"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils");exports.metadata={summary:"Lists all affiliate conditions",description:"Retrieves all affiliate conditions ordered by type and name. Returns conditions with reward details, types, and status information.",operationId:"listAffiliateConditions",tags:["Admin","Affiliate","Condition"],responses:{200:{description:"Affiliate conditions retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.mlmReferralConditionSchema}}}}},401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Affiliate Conditions"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"view.affiliate.condition",logModule:"ADMIN_AFFILIATE",logTitle:"List affiliate conditions"};exports.default=async e=>{const{ctx:i}=e;null==i||i.step("Fetching all affiliate conditions");const t=await db_1.models.mlmReferralCondition.findAll({order:[["type","ASC"],["name","ASC"]]});null==i||i.success("All conditions fetched successfully");return t};