"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize"),init_1=require("./init");class user extends sequelize_1.Model{static initModel(e){return user.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},email:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,unique:"email",validate:{isEmail:{msg:"email: Must be a valid email address"}},comment:"User's email address (unique identifier)"},password:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,validate:{len:{args:[8,255],msg:"password: Password must be between 8 and 255 characters long"}},comment:"Hashed password for authentication"},avatar:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0,validate:{is:{args:["^/(uploads|img)/.*$","i"],msg:"avatar: Must be a valid URL"}},comment:"URL path to user's profile picture"},firstName:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,validate:{is:{args:[/^[\p{L} \-'.]+$/u],msg:"firstName: First name can only contain letters, spaces, hyphens, apostrophes, and periods"}},comment:"User's first name"},lastName:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,validate:{is:{args:[/^[\p{L} \-'.]+$/u],msg:"lastName: Last name can only contain letters, spaces, hyphens, apostrophes, and periods"}},comment:"User's last name"},emailVerified:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1,comment:"Whether the user's email address has been verified"},phone:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,validate:{is:{args:["^[+0-9]+$","i"],msg:"phone: Phone number must contain only digits and can start with a plus sign"}},comment:"User's phone number with country code"},phoneVerified:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1,comment:"Whether the user's phone number has been verified"},roleId:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0,comment:"ID of the role assigned to this user"},profile:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("profile");return e?"string"==typeof e?JSON.parse(e):e:null},set(e){this.setDataValue("profile",JSON.stringify(e))},comment:"Additional user profile information in JSON format"},lastLogin:{type:sequelize_1.DataTypes.DATE,allowNull:!0,comment:"Timestamp of the user's last successful login"},lastFailedLogin:{type:sequelize_1.DataTypes.DATE,allowNull:!0,comment:"Timestamp of the user's last failed login attempt"},failedLoginAttempts:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0,defaultValue:0,comment:"Number of consecutive failed login attempts"},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","INACTIVE","SUSPENDED","BANNED"),allowNull:!0,defaultValue:"ACTIVE",comment:"Current status of the user account"},settings:{type:sequelize_1.DataTypes.JSON,allowNull:!0,defaultValue:{email:!0,sms:!0,push:!0},get(){const e=this.getDataValue("settings");return e?"string"==typeof e?JSON.parse(e):e:null},comment:"User notification and preference settings"}},{sequelize:e,modelName:"user",tableName:"user",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"id",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"email",unique:!0,using:"BTREE",fields:[{name:"email"}]},{name:"UserRoleIdFkey",using:"BTREE",fields:[{name:"roleId"}]}],hooks:{...(0,init_1.createUserCacheHooks)(e=>e.id)}})}static associate(e){user.hasMany(e.aiInvestment,{as:"aiInvestments",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasOne(e.author,{as:"author",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.binaryOrder,{as:"binaryOrder",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.comment,{as:"comments",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.ecommerceOrder,{as:"ecommerceOrders",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.ecommerceReview,{as:"ecommerceReviews",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasOne(e.ecommerceShippingAddress,{as:"ecommerceShippingAddress",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.ecommerceUserDiscount,{as:"ecommerceUserDiscounts",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.ecommerceWishlist,{as:"ecommerceWishlists",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.exchangeOrder,{as:"exchangeOrder",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.exchangeWatchlist,{as:"exchangeWatchlists",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.forexAccount,{as:"forexAccounts",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.forexInvestment,{as:"forexInvestments",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.investment,{as:"investments",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasOne(e.kycApplication,{as:"kyc",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.mlmReferral,{as:"referredReferrals",foreignKey:"referredId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.mlmReferral,{as:"referrerReferrals",foreignKey:"referrerId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.mlmReferralReward,{as:"referralRewards",foreignKey:"referrerId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.notification,{as:"notifications",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.providerUser,{as:"providers",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.belongsTo(e.role,{as:"role",foreignKey:"roleId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.supportTicket,{as:"supportTickets",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.supportTicket,{as:"agentSupportTickets",foreignKey:"agentId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.transaction,{as:"transactions",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasOne(e.twoFactor,{as:"twoFactor",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.wallet,{as:"wallets",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.walletPnl,{as:"walletPnls",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.icoTransaction,{as:"icoTransactions",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.icoAdminActivity,{as:"icoAdminActivities",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.p2pTrade,{as:"p2pTrades",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.p2pOffer,{as:"p2pOffers",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.p2pReview,{as:"p2pReviews",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasOne(e.nftCreator,{as:"nftCreator",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});user.hasMany(e.userBlock,{as:"blocks",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE",constraints:!1});user.hasMany(e.userBlock,{as:"adminBlocks",foreignKey:"adminId",onDelete:"CASCADE",onUpdate:"CASCADE",constraints:!1})}}exports.default=user;