"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize"),console_1=require("@b/utils/console");class supportTicket extends sequelize_1.Model{static initModel(e){return supportTicket.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,comment:"ID of the user who created this support ticket"},agentId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,comment:"ID of the support agent assigned to this ticket"},agentName:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,comment:"Agent display name for faster lookup"},subject:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,comment:"Subject/title of the support ticket"},importance:{type:sequelize_1.DataTypes.ENUM("LOW","MEDIUM","HIGH"),allowNull:!1,defaultValue:"LOW",comment:"Priority level of the support ticket"},messages:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("messages");if(!e)return[];if(Array.isArray(e))return e;if("string"==typeof e)try{const t=JSON.parse(e);return Array.isArray(t)?t:[]}catch(e){console_1.logger.error("TICKET",`Failed to parse messages JSON for ticket ${this.id}`,e);return[]}return[]},set(e){try{if(Array.isArray(e)&&e.every(e=>"object"==typeof e&&"string"==typeof e.type&&"string"==typeof e.text&&e.time))this.setDataValue("messages",e);else{if(null!=e){console_1.logger.error("TICKET",`Invalid messages format for ticket ${this.id}`);throw new Error("messages must be an array of message objects or null/undefined")}this.setDataValue("messages",e)}}catch(e){console_1.logger.error("TICKET",`Error setting messages for ticket ${this.id}`,e);throw e}},comment:"Array of chat messages between user and support agent"},status:{type:sequelize_1.DataTypes.ENUM("PENDING","OPEN","REPLIED","CLOSED"),allowNull:!1,defaultValue:"PENDING",comment:"Current status of the support ticket"},type:{type:sequelize_1.DataTypes.ENUM("LIVE","TICKET"),allowNull:!1,defaultValue:"TICKET",comment:"Type of support - live chat or ticket system"},tags:{type:sequelize_1.DataTypes.JSON,allowNull:!0,comment:"Tags for search/filter (string array)",get(){const e=this.getDataValue("tags");if(!e)return[];if(Array.isArray(e))return e;if("string"==typeof e)try{const t=JSON.parse(e);return Array.isArray(t)?t:[]}catch(e){console_1.logger.error("TICKET",`Failed to parse tags JSON for ticket ${this.id}`,e);return[]}return[]},set(e){try{if(Array.isArray(e)&&e.every(e=>"string"==typeof e))this.setDataValue("tags",e);else{if(null!=e){console_1.logger.error("TICKET",`Invalid tags format for ticket ${this.id}`);throw new Error("tags must be an array of strings or null/undefined")}this.setDataValue("tags",e)}}catch(e){console_1.logger.error("TICKET",`Error setting tags for ticket ${this.id}`,e);throw e}}},responseTime:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0,comment:"Minutes from creation to first agent reply"},satisfaction:{type:sequelize_1.DataTypes.FLOAT,allowNull:!0,comment:"Rating 1-5 from user"},createdAt:sequelize_1.DataTypes.DATE,updatedAt:sequelize_1.DataTypes.DATE,deletedAt:sequelize_1.DataTypes.DATE},{sequelize:e,modelName:"supportTicket",tableName:"support_ticket",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"agentId",using:"BTREE",fields:[{name:"agentId"}]},{name:"supportTicketUserIdForeign",using:"BTREE",fields:[{name:"userId"}]},{name:"tags_idx",using:"BTREE",fields:[{name:"tags",length:255}]}]})}static associate(e){supportTicket.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});supportTicket.belongsTo(e.user,{as:"agent",foreignKey:"agentId",onDelete:"SET NULL",onUpdate:"CASCADE"})}}exports.default=supportTicket;