"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const lodash_1=require("lodash"),sequelize_1=require("sequelize");class withdrawMethod extends sequelize_1.Model{static initModel(e){return withdrawMethod.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},title:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"title: Title cannot be empty"}},comment:"Display name of the withdrawal method"},processingTime:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"processingTime: Processing time cannot be empty"}},comment:"Expected processing time for withdrawals (e.g., '1-3 business days')"},instructions:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"instructions: Instructions cannot be empty"}},comment:"Step-by-step instructions for using this withdrawal method"},image:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0,comment:"URL path to the method's logo or icon"},fixedFee:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"fixedFee: Fixed fee must be a number"}},comment:"Fixed fee amount charged for withdrawals"},percentageFee:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"percentageFee: Percentage fee must be a number"}},comment:"Percentage fee charged on withdrawal amount"},minAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"minAmount: Minimum amount must be a number"}},comment:"Minimum withdrawal amount allowed"},maxAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"maxAmount: Maximum amount must be a number"}},comment:"Maximum withdrawal amount allowed"},customFields:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("customFields");return e?JSON.parse(e):null},set(e){this.setDataValue("customFields",JSON.stringify(e.filter(e=>e.title&&""!==e.title).map(e=>({name:(0,lodash_1.camelCase)(e.title.trim()),title:e.title.trim(),type:e.type,required:e.required}))))},comment:"Custom form fields required for this withdrawal method"},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!0,defaultValue:!0,comment:"Whether this withdrawal method is active and available"}},{sequelize:e,modelName:"withdrawMethod",tableName:"withdraw_method",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]}]})}static associate(e){}}exports.default=withdrawMethod;