"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class depositGateway extends sequelize_1.Model{static initModel(e){return depositGateway.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,unique:"depositGatewayNameKey",validate:{notEmpty:{msg:"name: Name must not be empty"}}},title:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"title: Title must not be empty"}}},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"description: Description must not be empty"}}},image:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0,validate:{is:{args:["^/(uploads|img)/.*$","i"],msg:"image: Image must be a valid URL"}}},alias:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,unique:"depositGatewayAliasKey"},currencies:{type:sequelize_1.DataTypes.JSON,allowNull:!0},fixedFee:{type:sequelize_1.DataTypes.JSON,allowNull:!0,defaultValue:0,get(){const e=this.getDataValue("fixedFee");if(null==e)return 0;if("string"==typeof e)try{return JSON.parse(e)}catch(t){return parseFloat(e)||0}return e},set(e){if("number"==typeof e)this.setDataValue("fixedFee",e);else if("object"==typeof e&&null!==e)this.setDataValue("fixedFee",e);else if("string"==typeof e){const t=parseFloat(e);this.setDataValue("fixedFee",isNaN(t)?0:t)}else this.setDataValue("fixedFee",0)}},percentageFee:{type:sequelize_1.DataTypes.JSON,allowNull:!0,defaultValue:0,get(){const e=this.getDataValue("percentageFee");if(null==e)return 0;if("string"==typeof e)try{return JSON.parse(e)}catch(t){return parseFloat(e)||0}return e},set(e){if("number"==typeof e)this.setDataValue("percentageFee",e);else if("object"==typeof e&&null!==e)this.setDataValue("percentageFee",e);else if("string"==typeof e){const t=parseFloat(e);this.setDataValue("percentageFee",isNaN(t)?0:t)}else this.setDataValue("percentageFee",0)}},minAmount:{type:sequelize_1.DataTypes.JSON,allowNull:!0,defaultValue:0,get(){const e=this.getDataValue("minAmount");if(null==e)return 0;if("string"==typeof e)try{return JSON.parse(e)}catch(t){return parseFloat(e)||0}return e},set(e){if("number"==typeof e)this.setDataValue("minAmount",e);else if("object"==typeof e&&null!==e)this.setDataValue("minAmount",e);else if("string"==typeof e){const t=parseFloat(e);this.setDataValue("minAmount",isNaN(t)?0:t)}else this.setDataValue("minAmount",0)}},maxAmount:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("maxAmount");if(null==e)return null;if("string"==typeof e)try{return JSON.parse(e)}catch(t){const a=parseFloat(e);return isNaN(a)?null:a}return e},set(e){if("number"==typeof e)this.setDataValue("maxAmount",e);else if("object"==typeof e&&null!==e)this.setDataValue("maxAmount",e);else if("string"==typeof e){const t=parseFloat(e);this.setDataValue("maxAmount",isNaN(t)?null:t)}else this.setDataValue("maxAmount",null)}},type:{type:sequelize_1.DataTypes.ENUM("FIAT","CRYPTO"),allowNull:!1,defaultValue:"FIAT",validate:{isIn:{args:[["FIAT","CRYPTO"]],msg:"type: Must be either 'FIAT' or 'CRYPTO'"}}},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0,validate:{isBoolean:{msg:"status: Status must be a boolean value"}}},version:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,defaultValue:"0.0.1"},productId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,unique:"depositGatewayProductIdKey",validate:{isUUID:{args:4,msg:"productId: Product ID must be a valid UUID"}}}},{sequelize:e,modelName:"depositGateway",tableName:"deposit_gateway",timestamps:!1,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"depositGatewayNameKey",unique:!0,using:"BTREE",fields:[{name:"name"}]},{name:"depositGatewayAliasKey",unique:!0,using:"BTREE",fields:[{name:"alias"}]},{name:"depositGatewayProductIdKey",unique:!0,using:"BTREE",fields:[{name:"productId"}]}]})}static associate(e){}getFixedFee(e){return"number"==typeof this.fixedFee?this.fixedFee:"object"==typeof this.fixedFee&&this.fixedFee&&e&&this.fixedFee[e.toUpperCase()]||0}getPercentageFee(e){return"number"==typeof this.percentageFee?this.percentageFee:"object"==typeof this.percentageFee&&this.percentageFee&&e&&this.percentageFee[e.toUpperCase()]||0}getMinAmount(e){return"number"==typeof this.minAmount?this.minAmount:"object"==typeof this.minAmount&&this.minAmount&&e&&this.minAmount[e.toUpperCase()]||0}getMaxAmount(e){return"number"==typeof this.maxAmount?this.maxAmount:"object"==typeof this.maxAmount&&this.maxAmount&&e&&this.maxAmount[e.toUpperCase()]||null}}exports.default=depositGateway;