"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class stakingEarningRecord extends sequelize_1.Model{static initModel(e){return stakingEarningRecord.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},positionId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"positionId: Position ID cannot be null"}}},amount:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{isFloat:{msg:"amount: Must be a valid number"},min:{args:[0],msg:"amount: Cannot be negative"}}},type:{type:sequelize_1.DataTypes.ENUM("REGULAR","BONUS","REFERRAL"),allowNull:!1,defaultValue:"REGULAR",validate:{isIn:{args:[["REGULAR","BONUS","REFERRAL"]],msg:"type: Must be one of: REGULAR, BONUS, REFERRAL"}}},description:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"description: Description must not be empty"}}},isClaimed:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},claimedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0}},{sequelize:e,modelName:"stakingEarningRecord",tableName:"staking_earning_records",paranoid:!0,timestamps:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"staking_earning_records_position_idx",fields:[{name:"positionId"}]},{name:"staking_earning_records_type_idx",fields:[{name:"type"}]},{name:"staking_earning_records_claimed_idx",fields:[{name:"isClaimed"}]},{name:"staking_earning_records_position_claimed_idx",fields:[{name:"positionId"},{name:"isClaimed"}]},{name:"staking_earning_records_claimed_at_idx",fields:[{name:"claimedAt"}]}]})}static associate(e){stakingEarningRecord.belongsTo(e.stakingPosition,{foreignKey:"positionId",as:"position",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=stakingEarningRecord;