"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class stakingAdminEarning extends sequelize_1.Model{static initModel(e){return stakingAdminEarning.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},poolId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"poolId: Pool ID cannot be null"}}},amount:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{isFloat:{msg:"amount: Must be a valid number"},min:{args:[0],msg:"amount: Cannot be negative"}}},isClaimed:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},type:{type:sequelize_1.DataTypes.ENUM("PLATFORM_FEE","EARLY_WITHDRAWAL_FEE","PERFORMANCE_FEE","OTHER"),allowNull:!1,validate:{notEmpty:{msg:"type: Type must not be empty"},isIn:{args:[["PLATFORM_FEE","EARLY_WITHDRAWAL_FEE","PERFORMANCE_FEE","OTHER"]],msg:"type: Must be one of: PLATFORM_FEE, EARLY_WITHDRAWAL_FEE, PERFORMANCE_FEE, OTHER"}}},currency:{type:sequelize_1.DataTypes.STRING(10),allowNull:!1,validate:{notEmpty:{msg:"currency: Currency must not be empty"}}}},{sequelize:e,modelName:"stakingAdminEarning",tableName:"staking_admin_earnings",paranoid:!0,timestamps:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"staking_admin_earnings_pool_idx",fields:[{name:"poolId"}]},{name:"staking_admin_earnings_claimed_idx",fields:[{name:"isClaimed"}]}]})}static associate(e){stakingAdminEarning.belongsTo(e.stakingPool,{foreignKey:"poolId",as:"pool",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=stakingAdminEarning;