"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class p2pReview extends sequelize_1.Model{static initModel(e){return p2pReview.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},reviewerId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"reviewerId cannot be null"},isUUID:{args:4,msg:"reviewerId must be a valid UUID"}}},revieweeId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"revieweeId cannot be null"},isUUID:{args:4,msg:"revieweeId must be a valid UUID"}}},tradeId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"tradeId must be a valid UUID"}}},communicationRating:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{isFloat:{msg:"communicationRating must be a number"},min:{args:[0],msg:"communicationRating cannot be negative"},max:{args:[100],msg:"communicationRating cannot exceed 100"}}},speedRating:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{isFloat:{msg:"speedRating must be a number"},min:{args:[0],msg:"speedRating cannot be negative"},max:{args:[100],msg:"speedRating cannot exceed 100"}}},trustRating:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{isFloat:{msg:"trustRating must be a number"},min:{args:[0],msg:"trustRating cannot be negative"},max:{args:[100],msg:"trustRating cannot exceed 100"}}},comment:{type:sequelize_1.DataTypes.TEXT,allowNull:!0}},{sequelize:e,modelName:"p2pReview",tableName:"p2p_reviews",timestamps:!0,paranoid:!0})}static associate(e){p2pReview.belongsTo(e.user,{as:"reviewer",foreignKey:"reviewerId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pReview.belongsTo(e.user,{as:"reviewee",foreignKey:"revieweeId",onDelete:"CASCADE",onUpdate:"CASCADE"});p2pReview.belongsTo(e.p2pTrade,{as:"trade",foreignKey:"tradeId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=p2pReview;