"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftToken extends sequelize_1.Model{static initModel(e){return nftToken.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},collectionId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"collectionId: Collection ID cannot be null"},isUUID:{args:4,msg:"collectionId: Collection ID must be a valid UUID"}}},tokenId:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"tokenId: Token ID must not be empty"}}},name:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"name: Token name must not be empty"},len:{args:[1,255],msg:"name: Token name must be between 1 and 255 characters"}}},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},image:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0},attributes:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("attributes");return e?JSON.parse(e):null},set(e){this.setDataValue("attributes",JSON.stringify(e))}},metadataUri:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0,validate:{isUrl:{msg:"metadataUri: Metadata URI must be a valid URL"}}},metadataHash:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0},ownerWalletAddress:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,validate:{is:{args:/^0x[a-fA-F0-9]{40}$/,msg:"ownerWalletAddress: Must be a valid Ethereum address"}}},ownerId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"ownerId: Owner ID must be a valid UUID"}}},creatorId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"creatorId: Creator ID cannot be null"},isUUID:{args:4,msg:"creatorId: Creator ID must be a valid UUID"}}},mintedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},isMinted:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},isListed:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},views:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{min:{args:[0],msg:"views: Views must be non-negative"}}},likes:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{min:{args:[0],msg:"likes: Likes must be non-negative"}}},rarity:{type:sequelize_1.DataTypes.ENUM("COMMON","UNCOMMON","RARE","EPIC","LEGENDARY"),allowNull:!0,validate:{isIn:{args:[["COMMON","UNCOMMON","RARE","EPIC","LEGENDARY"]],msg:"rarity: Rarity must be one of 'COMMON', 'UNCOMMON', 'RARE', 'EPIC', or 'LEGENDARY'"}}},rarityScore:{type:sequelize_1.DataTypes.DECIMAL(10,2),allowNull:!0,validate:{min:{args:[0],msg:"rarityScore: Rarity score must be non-negative"}}},status:{type:sequelize_1.DataTypes.ENUM("DRAFT","MINTED","BURNED"),allowNull:!1,defaultValue:"DRAFT",validate:{isIn:{args:[["DRAFT","MINTED","BURNED"]],msg:"status: Status must be one of 'DRAFT', 'MINTED', or 'BURNED'"}}}},{sequelize:e,modelName:"nftToken",tableName:"nft_token",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"nftTokenCollectionTokenKey",unique:!0,using:"BTREE",fields:[{name:"collectionId"},{name:"tokenId"}]},{name:"nftTokenCollectionIdx",using:"BTREE",fields:[{name:"collectionId"}]},{name:"nftTokenOwnerIdx",using:"BTREE",fields:[{name:"ownerId"}]},{name:"nftTokenCreatorIdx",using:"BTREE",fields:[{name:"creatorId"}]},{name:"nftTokenStatusIdx",using:"BTREE",fields:[{name:"status"}]},{name:"nftTokenListedIdx",using:"BTREE",fields:[{name:"isListed"}]}]})}static associate(e){nftToken.belongsTo(e.nftCollection,{as:"collection",foreignKey:"collectionId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftToken.belongsTo(e.user,{as:"owner",foreignKey:"ownerId",onDelete:"SET NULL",onUpdate:"CASCADE"});nftToken.belongsTo(e.nftCreator,{as:"creator",foreignKey:"creatorId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftToken.hasMany(e.nftListing,{as:"listings",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftToken.hasOne(e.nftListing,{as:"currentListing",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE",scope:{status:"ACTIVE"}});nftToken.hasMany(e.nftActivity,{as:"activities",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftToken.hasMany(e.nftFavorite,{as:"favorites",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftToken.hasMany(e.nftSale,{as:"sales",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftToken.hasMany(e.nftOffer,{as:"offers",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=nftToken;