"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftFractional extends sequelize_1.Model{static initModel(e){return nftFractional.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},tokenId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,unique:!0,validate:{notNull:{msg:"tokenId: Token ID is required"},isUUID:{args:4,msg:"tokenId: Must be a valid UUID"}}},vaultAddress:{type:sequelize_1.DataTypes.STRING(42),allowNull:!0,validate:{is:{args:/^0x[a-fA-F0-9]{40}$/,msg:"vaultAddress: Must be a valid Ethereum address"}}},totalShares:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{notNull:{msg:"totalShares: Total shares is required"},min:{args:[100],msg:"totalShares: Minimum 100 shares"},max:{args:[1e6],msg:"totalShares: Maximum 1M shares"}}},availableShares:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{min:{args:[0],msg:"availableShares: Cannot be negative"}}},sharePrice:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!1,validate:{notNull:{msg:"sharePrice: Share price is required"},isDecimal:{msg:"sharePrice: Must be a valid decimal"},min:{args:[1e-6],msg:"sharePrice: Must be greater than 0"}}},currency:{type:sequelize_1.DataTypes.STRING(10),allowNull:!1,defaultValue:"ETH",validate:{isIn:{args:[["ETH","USDC","USDT","DAI","MATIC","BNB"]],msg:"currency: Invalid currency"}}},minPurchase:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:1,validate:{min:{args:[1],msg:"minPurchase: Minimum is 1 share"}}},maxPurchase:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:1e3,validate:{min:{args:[1],msg:"maxPurchase: Minimum is 1 share"}}},buyoutPrice:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!0,validate:{isDecimal:{msg:"buyoutPrice: Must be a valid decimal"},min:{args:[0],msg:"buyoutPrice: Cannot be negative"}}},buyoutEnabled:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},votingEnabled:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},status:{type:sequelize_1.DataTypes.ENUM("PENDING","ACTIVE","BUYOUT_PENDING","BOUGHT_OUT","CANCELLED"),allowNull:!1,defaultValue:"PENDING"},createdById:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"createdById: Creator ID is required"},isUUID:{args:4,msg:"createdById: Must be a valid UUID"}}},deployedAt:{type:sequelize_1.DataTypes.DATE(3),allowNull:!0},buyoutAt:{type:sequelize_1.DataTypes.DATE(3),allowNull:!0},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("metadata");return e?JSON.parse(e):null},set(e){this.setDataValue("metadata",e?JSON.stringify(e):null)}}},{sequelize:e,modelName:"nftFractional",tableName:"nft_fractional",timestamps:!0,paranoid:!1,indexes:[{name:"idx_nft_fractional_token",fields:["tokenId"],unique:!0},{name:"idx_nft_fractional_status",fields:["status"]},{name:"idx_nft_fractional_creator",fields:["createdById"]},{name:"idx_nft_fractional_vault",fields:["vaultAddress"]}]})}static associate(e){nftFractional.belongsTo(e.nftToken,{as:"token",foreignKey:"tokenId"});nftFractional.belongsTo(e.user,{as:"creator",foreignKey:"createdById"})}}exports.default=nftFractional;