"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftFavorite extends sequelize_1.Model{static initModel(e){return nftFavorite.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}}},tokenId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"tokenId: Token ID must be a valid UUID"}}},collectionId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"collectionId: Collection ID must be a valid UUID"}}}},{sequelize:e,modelName:"nftFavorite",tableName:"nft_favorite",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"nftFavoriteUserTokenKey",unique:!0,using:"BTREE",fields:[{name:"userId"},{name:"tokenId"}]},{name:"nftFavoriteUserCollectionKey",unique:!0,using:"BTREE",fields:[{name:"userId"},{name:"collectionId"}]},{name:"nftFavoriteUserIdx",using:"BTREE",fields:[{name:"userId"}]},{name:"nftFavoriteTokenIdx",using:"BTREE",fields:[{name:"tokenId"}]},{name:"nftFavoriteCollectionIdx",using:"BTREE",fields:[{name:"collectionId"}]}],validate:{eitherTokenOrCollection(){if(!this.tokenId&&!this.collectionId)throw new Error("Either tokenId or collectionId must be provided");if(this.tokenId&&this.collectionId)throw new Error("Cannot favorite both token and collection simultaneously")}}})}static associate(e){nftFavorite.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftFavorite.belongsTo(e.nftToken,{as:"token",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftFavorite.belongsTo(e.nftCollection,{as:"collection",foreignKey:"collectionId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=nftFavorite;