"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftDispute extends sequelize_1.Model{static initModel(e){return nftDispute.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},listingId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"listingId: Must be a valid UUID"}}},tokenId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"tokenId: Must be a valid UUID"}}},transactionHash:{type:sequelize_1.DataTypes.STRING(66),allowNull:!0,validate:{is:{args:/^0x[a-fA-F0-9]{64}$/,msg:"transactionHash: Must be a valid transaction hash"}}},disputeType:{type:sequelize_1.DataTypes.ENUM("FAKE_NFT","COPYRIGHT_INFRINGEMENT","SCAM","NOT_RECEIVED","WRONG_ITEM","UNAUTHORIZED_SALE","OTHER"),allowNull:!1,validate:{notNull:{msg:"disputeType: Dispute type is required"},isIn:{args:[["FAKE_NFT","COPYRIGHT_INFRINGEMENT","SCAM","NOT_RECEIVED","WRONG_ITEM","UNAUTHORIZED_SALE","OTHER"]],msg:"disputeType: Invalid dispute type"}}},status:{type:sequelize_1.DataTypes.ENUM("PENDING","INVESTIGATING","AWAITING_RESPONSE","RESOLVED","REJECTED","ESCALATED"),allowNull:!1,defaultValue:"PENDING",validate:{isIn:{args:[["PENDING","INVESTIGATING","AWAITING_RESPONSE","RESOLVED","REJECTED","ESCALATED"]],msg:"status: Invalid status"}}},priority:{type:sequelize_1.DataTypes.ENUM("LOW","MEDIUM","HIGH","CRITICAL"),allowNull:!1,defaultValue:"MEDIUM",validate:{isIn:{args:[["LOW","MEDIUM","HIGH","CRITICAL"]],msg:"priority: Invalid priority level"}}},reporterId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"reporterId: Reporter ID is required"},isUUID:{args:4,msg:"reporterId: Must be a valid UUID"}}},respondentId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"respondentId: Must be a valid UUID"}}},assignedToId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"assignedToId: Must be a valid UUID"}}},title:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"title: Title cannot be empty"},len:{args:[1,255],msg:"title: Title must be between 1 and 255 characters"}}},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"description: Description cannot be empty"},len:{args:[10,5e3],msg:"description: Description must be between 10 and 5000 characters"}}},evidence:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("evidence");return e?JSON.parse(e):null},set(e){this.setDataValue("evidence",e?JSON.stringify(e):null)}},resolution:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},resolutionType:{type:sequelize_1.DataTypes.ENUM("REFUND","CANCEL_SALE","REMOVE_LISTING","BAN_USER","WARNING","NO_ACTION"),allowNull:!0,validate:{isIn:{args:[["REFUND","CANCEL_SALE","REMOVE_LISTING","BAN_USER","WARNING","NO_ACTION"]],msg:"resolutionType: Invalid resolution type"}}},refundAmount:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!0,validate:{isDecimal:{msg:"refundAmount: Must be a valid decimal number"},min:{args:[0],msg:"refundAmount: Cannot be negative"}}},escalatedAt:{type:sequelize_1.DataTypes.DATE(3),allowNull:!0},investigatedAt:{type:sequelize_1.DataTypes.DATE(3),allowNull:!0},resolvedAt:{type:sequelize_1.DataTypes.DATE(3),allowNull:!0},resolvedById:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"resolvedById: Must be a valid UUID"}}},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("metadata");return e?JSON.parse(e):null},set(e){this.setDataValue("metadata",e?JSON.stringify(e):null)}}},{sequelize:e,modelName:"nftDispute",tableName:"nft_dispute",timestamps:!0,paranoid:!1,indexes:[{name:"idx_nft_dispute_status",fields:["status"]},{name:"idx_nft_dispute_priority",fields:["priority"]},{name:"idx_nft_dispute_reporter",fields:["reporterId"]},{name:"idx_nft_dispute_respondent",fields:["respondentId"]},{name:"idx_nft_dispute_assigned",fields:["assignedToId"]},{name:"idx_nft_dispute_listing",fields:["listingId"]},{name:"idx_nft_dispute_token",fields:["tokenId"]},{name:"idx_nft_dispute_created",fields:["createdAt"]}]})}static associate(e){nftDispute.belongsTo(e.user,{as:"reporter",foreignKey:"reporterId"});nftDispute.belongsTo(e.user,{as:"respondent",foreignKey:"respondentId"});nftDispute.belongsTo(e.user,{as:"assignedTo",foreignKey:"assignedToId"});nftDispute.belongsTo(e.user,{as:"resolvedBy",foreignKey:"resolvedById"});nftDispute.belongsTo(e.nftListing,{as:"listing",foreignKey:"listingId"});nftDispute.belongsTo(e.nftToken,{as:"token",foreignKey:"tokenId"});nftDispute.hasMany(e.nftDisputeMessage,{as:"messages",foreignKey:"disputeId"})}}exports.default=nftDispute;