"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftComment extends sequelize_1.Model{static initModel(e){return nftComment.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},tokenId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"tokenId: Must be a valid UUID"}}},collectionId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"collectionId: Must be a valid UUID"}}},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID is required"},isUUID:{args:4,msg:"userId: Must be a valid UUID"}}},parentId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"parentId: Must be a valid UUID"}}},content:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"content: Comment cannot be empty"},len:{args:[1,5e3],msg:"content: Comment must be between 1 and 5000 characters"}}},likes:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{min:{args:[0],msg:"likes: Cannot be negative"}}},isEdited:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},isDeleted:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("metadata");return e?JSON.parse(e):null},set(e){this.setDataValue("metadata",e?JSON.stringify(e):null)}}},{sequelize:e,modelName:"nftComment",tableName:"nft_comment",timestamps:!0,paranoid:!1,indexes:[{name:"idx_nft_comment_token",fields:["tokenId"]},{name:"idx_nft_comment_collection",fields:["collectionId"]},{name:"idx_nft_comment_user",fields:["userId"]},{name:"idx_nft_comment_parent",fields:["parentId"]},{name:"idx_nft_comment_created",fields:["createdAt"]}]})}static associate(e){nftComment.belongsTo(e.user,{as:"user",foreignKey:"userId"});nftComment.belongsTo(e.nftToken,{as:"token",foreignKey:"tokenId"});nftComment.belongsTo(e.nftCollection,{as:"collection",foreignKey:"collectionId"});nftComment.belongsTo(e.nftComment,{as:"parent",foreignKey:"parentId"});nftComment.hasMany(e.nftComment,{as:"replies",foreignKey:"parentId"})}}exports.default=nftComment;