"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class icoTransaction extends sequelize_1.Model{static initModel(e){return icoTransaction.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}}},offeringId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"offeringId: Offering ID cannot be null"},isUUID:{args:4,msg:"offeringId: Offering ID must be a valid UUID"}}},amount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"amount: Must be a valid number"},min:{args:[0],msg:"amount: Cannot be negative"}}},price:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"price: Must be a valid number"},min:{args:[0],msg:"price: Cannot be negative"}}},status:{type:sequelize_1.DataTypes.ENUM("PENDING","VERIFICATION","RELEASED","REJECTED"),allowNull:!1,defaultValue:"PENDING",validate:{isIn:{args:[["PENDING","VERIFICATION","RELEASED","REJECTED"]],msg:"status: Must be 'PENDING', 'VERIFICATION', 'RELEASED' or 'REJECTED'"}}},releaseUrl:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},walletAddress:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},notes:{type:sequelize_1.DataTypes.TEXT,allowNull:!0}},{sequelize:e,modelName:"icoTransaction",tableName:"ico_transaction",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"icoTransactionOfferingIdUserIdKey",fields:[{name:"offeringId"},{name:"userId"}]}]})}static associate(e){icoTransaction.belongsTo(e.icoTokenOffering,{as:"offering",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTransaction.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=icoTransaction;