"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class icoTokenVesting extends sequelize_1.Model{static initModel(e){return icoTokenVesting.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0},transactionId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,references:{model:"ico_transaction",key:"id"},onDelete:"CASCADE"},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,references:{model:"user",key:"id"},onDelete:"CASCADE"},offeringId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,references:{model:"ico_token_offering",key:"id"},onDelete:"CASCADE"},totalAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{min:0}},releasedAmount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,defaultValue:0,validate:{min:0}},vestingType:{type:sequelize_1.DataTypes.ENUM("LINEAR","CLIFF","MILESTONE"),allowNull:!1,defaultValue:"LINEAR"},startDate:{type:sequelize_1.DataTypes.DATE,allowNull:!1},endDate:{type:sequelize_1.DataTypes.DATE,allowNull:!1},cliffDuration:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0,comment:"Cliff duration in days"},releaseSchedule:{type:sequelize_1.DataTypes.JSON,allowNull:!0,comment:"JSON array of milestone releases [{date, percentage, amount}]"},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","COMPLETED","CANCELLED"),allowNull:!1,defaultValue:"ACTIVE"}},{sequelize:e,modelName:"icoTokenVesting",tableName:"ico_token_vesting",timestamps:!0,paranoid:!0,indexes:[{fields:["transactionId"]},{fields:["userId"]},{fields:["offeringId"]},{fields:["status"]},{fields:["startDate","endDate"]}]})}static associate(e){icoTokenVesting.hasMany(e.icoTokenVestingRelease,{as:"releases",foreignKey:"vestingId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenVesting.belongsTo(e.icoTransaction,{as:"transaction",foreignKey:"transactionId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenVesting.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenVesting.belongsTo(e.icoTokenOffering,{as:"offering",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=icoTokenVesting;