"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class icoTokenDetail extends sequelize_1.Model{static initModel(e){return icoTokenDetail.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},offeringId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"offeringId: Offering ID cannot be null"},isUUID:{args:4,msg:"offeringId: Offering ID must be a valid UUID"}}},tokenType:{type:sequelize_1.DataTypes.STRING(50),allowNull:!1,validate:{notEmpty:{msg:"tokenType: Token type must not be empty"}}},totalSupply:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"totalSupply: Must be a valid number"},min:{args:[0],msg:"totalSupply: Cannot be negative"}}},tokensForSale:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"tokensForSale: Must be a valid number"},min:{args:[0],msg:"tokensForSale: Cannot be negative"}}},salePercentage:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"salePercentage: Must be a valid number"},min:{args:[0],msg:"salePercentage: Cannot be negative"},max:{args:[100],msg:"salePercentage: Cannot exceed 100"}}},blockchain:{type:sequelize_1.DataTypes.STRING(100),allowNull:!1,validate:{notEmpty:{msg:"blockchain: Blockchain must not be empty"}}},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"description: Description must not be empty"}}},useOfFunds:{type:sequelize_1.DataTypes.JSON,allowNull:!1},links:{type:sequelize_1.DataTypes.JSON,allowNull:!1}},{sequelize:e,modelName:"icoTokenDetail",tableName:"ico_token_detail",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"icoTokenDetailOfferingIdKey",unique:!0,fields:[{name:"offeringId"}]}]})}static associate(e){icoTokenDetail.belongsTo(e.icoTokenOffering,{as:"offering",foreignKey:"offeringId",onDelete:"CASCADE",onUpdate:"CASCADE"});icoTokenDetail.belongsTo(e.icoTokenType,{as:"tokenTypeData",foreignKey:"tokenType",targetKey:"id",constraints:!1})}}exports.default=icoTokenDetail;