"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class gatewayMerchant extends sequelize_1.Model{static initModel(e){return gatewayMerchant.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"userId: Must be a valid UUID"}}},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"name: Business name must not be empty"},len:{args:[2,191],msg:"name: Must be between 2 and 191 characters"}}},slug:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},logo:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0},website:{type:sequelize_1.DataTypes.STRING(500),allowNull:!0,validate:{isValidUrl(e){if(e&&!/^https?:\/\/.+/.test(e))throw new Error("website: Must be a valid URL")}}},email:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{isEmail:{msg:"email: Must be a valid email address"}}},phone:{type:sequelize_1.DataTypes.STRING(50),allowNull:!0},address:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},city:{type:sequelize_1.DataTypes.STRING(100),allowNull:!0},state:{type:sequelize_1.DataTypes.STRING(100),allowNull:!0},country:{type:sequelize_1.DataTypes.STRING(100),allowNull:!0},postalCode:{type:sequelize_1.DataTypes.STRING(20),allowNull:!0},apiKey:{type:sequelize_1.DataTypes.STRING(64),allowNull:!1},secretKey:{type:sequelize_1.DataTypes.STRING(64),allowNull:!1},webhookSecret:{type:sequelize_1.DataTypes.STRING(64),allowNull:!1},testMode:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0},allowedCurrencies:{type:sequelize_1.DataTypes.JSON,allowNull:!1,defaultValue:["USD"],get(){const e=this.getDataValue("allowedCurrencies");return"string"==typeof e?JSON.parse(e):e}},allowedWalletTypes:{type:sequelize_1.DataTypes.JSON,allowNull:!1,defaultValue:["FIAT"],get(){const e=this.getDataValue("allowedWalletTypes");return"string"==typeof e?JSON.parse(e):e}},defaultCurrency:{type:sequelize_1.DataTypes.STRING(20),allowNull:!1,defaultValue:"USD"},feeType:{type:sequelize_1.DataTypes.ENUM("PERCENTAGE","FIXED","BOTH"),allowNull:!1,defaultValue:"BOTH"},feePercentage:{type:sequelize_1.DataTypes.DECIMAL(10,4),allowNull:!1,defaultValue:2.9,get(){const e=this.getDataValue("feePercentage");return e?parseFloat(e.toString()):0}},feeFixed:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:.3,get(){const e=this.getDataValue("feeFixed");return e?parseFloat(e.toString()):0}},payoutSchedule:{type:sequelize_1.DataTypes.ENUM("INSTANT","DAILY","WEEKLY","MONTHLY"),allowNull:!1,defaultValue:"DAILY"},payoutThreshold:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:100,get(){const e=this.getDataValue("payoutThreshold");return e?parseFloat(e.toString()):0}},payoutWalletId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},status:{type:sequelize_1.DataTypes.ENUM("PENDING","ACTIVE","SUSPENDED","REJECTED"),allowNull:!1,defaultValue:"PENDING"},verificationStatus:{type:sequelize_1.DataTypes.ENUM("UNVERIFIED","PENDING","VERIFIED"),allowNull:!1,defaultValue:"UNVERIFIED"},dailyLimit:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:1e4,get(){const e=this.getDataValue("dailyLimit");return e?parseFloat(e.toString()):0}},monthlyLimit:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:1e5,get(){const e=this.getDataValue("monthlyLimit");return e?parseFloat(e.toString()):0}},transactionLimit:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,defaultValue:5e3,get(){const e=this.getDataValue("transactionLimit");return e?parseFloat(e.toString()):0}},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("metadata");return"string"==typeof e?JSON.parse(e):e}}},{sequelize:e,modelName:"gatewayMerchant",tableName:"gateway_merchant",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"gatewayMerchantUserIdFkey",using:"BTREE",fields:[{name:"userId"}]},{name:"gatewayMerchantApiKeyUnique",unique:!0,using:"BTREE",fields:[{name:"apiKey"}]},{name:"gatewayMerchantSecretKeyUnique",unique:!0,using:"BTREE",fields:[{name:"secretKey"}]},{name:"gatewayMerchantSlugUnique",unique:!0,using:"BTREE",fields:[{name:"slug"}]},{name:"gatewayMerchantStatusIdx",using:"BTREE",fields:[{name:"status"}]}],hooks:{async beforeValidate(e){!e.slug&&e.name&&(e.slug=await gatewayMerchant.generateUniqueSlug(e.name))}}})}static associate(e){gatewayMerchant.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayMerchant.hasMany(e.gatewayApiKey,{as:"gatewayApiKeys",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayMerchant.hasMany(e.gatewayPayment,{as:"gatewayPayments",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayMerchant.hasMany(e.gatewayRefund,{as:"gatewayRefunds",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayMerchant.hasMany(e.gatewayWebhook,{as:"gatewayWebhooks",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayMerchant.hasMany(e.gatewayPayout,{as:"gatewayPayouts",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayMerchant.hasMany(e.gatewayMerchantBalance,{as:"gatewayMerchantBalances",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"})}static async generateUniqueSlug(e){const a=e.toLowerCase().replace(/[^a-z0-9]+/g,"-").replace(/^-+|-+$/g,"");let t=a,l=1;for(;await gatewayMerchant.findOne({where:{slug:t}});){t=`${a}-${l}`;l++}return t}}exports.default=gatewayMerchant;