"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class ecosystemToken extends sequelize_1.Model{static initModel(e){return ecosystemToken.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},name:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"name: Name must not be empty"}}},currency:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"currency: Currency must not be empty"}}},chain:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"chain: Chain must not be empty"}}},network:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"network: Network must not be empty"}}},contract:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"contract: Contract must not be empty"}}},contractType:{type:sequelize_1.DataTypes.ENUM("PERMIT","NO_PERMIT","NATIVE"),allowNull:!1,defaultValue:"PERMIT",validate:{isIn:{args:[["PERMIT","NO_PERMIT","NATIVE"]],msg:"contractType: Contract Type must be one of 'PERMIT', 'NO_PERMIT', or 'NATIVE'"}}},type:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"type: Type must not be empty"}}},decimals:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{isInt:{msg:"decimals: Decimals must be an integer"}}},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0,validate:{isBoolean:{msg:"status: Status must be a boolean value"}}},precision:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0,defaultValue:8},limits:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("limits");return e?JSON.parse(e):null}},fee:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("fee");return e?JSON.parse(e):null}},icon:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!0,validate:{is:{args:["^/(uploads|img|blockchains)/.*$","i"],msg:"icon: icon must be a valid URL"}}}},{sequelize:e,modelName:"ecosystemToken",tableName:"ecosystem_token",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"ecosystemTokenContractChainKey",unique:!0,using:"BTREE",fields:[{name:"contract"},{name:"chain"}]}]})}static associate(e){}}exports.default=ecosystemToken;