"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class ecommerceReview extends sequelize_1.Model{static initModel(e){return ecommerceReview.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},productId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"productId: Product ID cannot be null"},isUUID:{args:4,msg:"productId: Product ID must be a valid UUID"}}},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}}},rating:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{isInt:{msg:"rating: Rating must be an integer"},min:{args:[1],msg:"rating: Rating must be at least 1"},max:{args:[5],msg:"rating: Rating must be no more than 5"}}},comment:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,validate:{len:{args:[0,191],msg:"comment: Comment cannot exceed 191 characters"}}},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0,validate:{isBoolean:{msg:"status: Status must be a boolean value"}}}},{sequelize:e,modelName:"ecommerceReview",tableName:"ecommerce_review",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"ecommerceReviewProductIdUserIdUnique",unique:!0,using:"BTREE",fields:[{name:"productId"},{name:"userId"}]},{name:"ecommerceReviewUserIdFkey",using:"BTREE",fields:[{name:"userId"}]}]})}static associate(e){ecommerceReview.belongsTo(e.ecommerceProduct,{as:"product",foreignKey:"productId",onDelete:"CASCADE",onUpdate:"CASCADE"});ecommerceReview.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=ecommerceReview;