"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class ecommerceProduct extends sequelize_1.Model{static initModel(e){return ecommerceProduct.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"name: Name must not be empty"}}},slug:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1},description:{type:sequelize_1.DataTypes.TEXT("long"),allowNull:!1,validate:{notEmpty:{msg:"description: Description must not be empty"}}},shortDescription:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},type:{type:sequelize_1.DataTypes.ENUM("DOWNLOADABLE","PHYSICAL"),allowNull:!1,validate:{isIn:{args:[["DOWNLOADABLE","PHYSICAL"]],msg:"type: Must be either 'DOWNLOADABLE' or 'PHYSICAL'"}}},price:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"price: Price must be a valid number"},min:{args:[0],msg:"price: Price cannot be negative"}}},categoryId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"categoryId: Category ID must be a valid UUID"}}},inventoryQuantity:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{isInt:{msg:"inventoryQuantity: Inventory quantity must be an integer"},min:{args:[0],msg:"inventoryQuantity: Inventory quantity cannot be negative"}}},status:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0,validate:{isBoolean:{msg:"status: Status must be a boolean value"}}},image:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,validate:{is:{args:["^/(uploads|img)/.*$","i"],msg:"image: Image must be a valid URL"}}},currency:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,defaultValue:"USD",validate:{notEmpty:{msg:"currency: Currency must not be empty"}}},walletType:{type:sequelize_1.DataTypes.ENUM("FIAT","SPOT","ECO"),allowNull:!1,defaultValue:"SPOT",validate:{isIn:{args:[["FIAT","SPOT","ECO"]],msg:"walletType: Must be either 'FIAT', 'SPOT', or 'ECO'"}}}},{sequelize:e,modelName:"ecommerceProduct",tableName:"ecommerce_product",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"ecommerceProductCategoryIdFkey",using:"BTREE",fields:[{name:"categoryId"}]}],hooks:{async beforeValidate(e){!e.slug&&e.name&&(e.slug=await ecommerceProduct.generateUniqueSlug(e.name))}}})}static associate(e){ecommerceProduct.belongsTo(e.ecommerceCategory,{as:"category",foreignKey:"categoryId",onDelete:"CASCADE",onUpdate:"CASCADE"});ecommerceProduct.hasMany(e.ecommerceDiscount,{as:"ecommerceDiscounts",foreignKey:"productId",onDelete:"CASCADE",onUpdate:"CASCADE"});ecommerceProduct.hasMany(e.ecommerceReview,{as:"ecommerceReviews",foreignKey:"productId",onDelete:"CASCADE",onUpdate:"CASCADE"});ecommerceProduct.hasMany(e.ecommerceOrderItem,{as:"ecommerceOrderItems",foreignKey:"productId",onDelete:"CASCADE",onUpdate:"CASCADE"});ecommerceProduct.belongsToMany(e.ecommerceOrder,{as:"orders",through:e.ecommerceOrderItem,foreignKey:"productId",otherKey:"orderId",onDelete:"CASCADE",onUpdate:"CASCADE"});ecommerceProduct.belongsToMany(e.ecommerceShipping,{as:"shippings",through:e.ecommerceOrder,foreignKey:"productId",otherKey:"shippingId",onDelete:"CASCADE",onUpdate:"CASCADE"});ecommerceProduct.hasMany(e.ecommerceWishlistItem,{as:"wishlistItems",foreignKey:"productId",onDelete:"CASCADE",onUpdate:"CASCADE"});ecommerceProduct.belongsToMany(e.ecommerceWishlist,{as:"wishlists",through:e.ecommerceWishlistItem,foreignKey:"productId",otherKey:"wishlistId",onDelete:"CASCADE",onUpdate:"CASCADE"})}static async generateUniqueSlug(e){const t=e.toLowerCase().replace(/[^a-z0-9]+/g,"-").replace(/^-+|-+$/g,"");let a=t,o=1;for(;await ecommerceProduct.findOne({where:{slug:a}});){a=`${t}-${o}`;o++}return a}}exports.default=ecommerceProduct;