"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class copyTradingTransaction extends sequelize_1.Model{static initModel(e){return copyTradingTransaction.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID is required"}}},leaderId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},followerId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},tradeId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},type:{type:sequelize_1.DataTypes.ENUM("ALLOCATION","DEALLOCATION","PROFIT_SHARE","TRADE_PROFIT","TRADE_LOSS","FEE","REFUND"),allowNull:!1},amount:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1},currency:{type:sequelize_1.DataTypes.STRING(20),allowNull:!1,defaultValue:"USDT"},fee:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:0},balanceBefore:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:0},balanceAfter:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:0},status:{type:sequelize_1.DataTypes.ENUM("PENDING","COMPLETED","FAILED"),allowNull:!1,defaultValue:"COMPLETED"},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},metadata:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},createdAt:{type:sequelize_1.DataTypes.DATE,allowNull:!1,defaultValue:sequelize_1.DataTypes.NOW},updatedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!1,defaultValue:sequelize_1.DataTypes.NOW}},{sequelize:e,modelName:"copyTradingTransaction",tableName:"copy_trading_transactions",timestamps:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"copy_trading_transactions_user_id_idx",fields:[{name:"userId"}]},{name:"copy_trading_transactions_leader_id_idx",fields:[{name:"leaderId"}]},{name:"copy_trading_transactions_follower_id_idx",fields:[{name:"followerId"}]},{name:"copy_trading_transactions_trade_id_idx",fields:[{name:"tradeId"}]},{name:"copy_trading_transactions_type_idx",fields:[{name:"type"}]},{name:"copy_trading_transactions_status_idx",fields:[{name:"status"}]},{name:"copy_trading_transactions_created_at_idx",fields:[{name:"createdAt"}]}]})}static associate(e){copyTradingTransaction.belongsTo(e.user,{foreignKey:"userId",as:"user",onDelete:"CASCADE",onUpdate:"CASCADE"});copyTradingTransaction.belongsTo(e.copyTradingLeader,{foreignKey:"leaderId",as:"leader",onDelete:"SET NULL",onUpdate:"CASCADE"});copyTradingTransaction.belongsTo(e.copyTradingFollower,{foreignKey:"followerId",as:"follower",onDelete:"SET NULL",onUpdate:"CASCADE"});copyTradingTransaction.belongsTo(e.copyTradingTrade,{foreignKey:"tradeId",as:"trade",onDelete:"SET NULL",onUpdate:"CASCADE"})}}exports.default=copyTradingTransaction;