"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class copyTradingTrade extends sequelize_1.Model{static initModel(e){return copyTradingTrade.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},leaderId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"leaderId: Leader ID is required"}}},followerId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},leaderOrderId:{type:sequelize_1.DataTypes.STRING(100),allowNull:!0},symbol:{type:sequelize_1.DataTypes.STRING(20),allowNull:!1,validate:{notEmpty:{msg:"symbol: Symbol is required"}}},side:{type:sequelize_1.DataTypes.ENUM("BUY","SELL"),allowNull:!1},type:{type:sequelize_1.DataTypes.ENUM("MARKET","LIMIT"),allowNull:!1,defaultValue:"MARKET"},amount:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{min:{args:[0],msg:"amount: Cannot be negative"}}},price:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{min:{args:[0],msg:"price: Cannot be negative"}}},cost:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:0},fee:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:0},feeCurrency:{type:sequelize_1.DataTypes.STRING(20),allowNull:!1,defaultValue:"USDT"},executedAmount:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:0},executedPrice:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:0},slippage:{type:sequelize_1.DataTypes.FLOAT,allowNull:!0},latencyMs:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0},profit:{type:sequelize_1.DataTypes.FLOAT,allowNull:!0},profitPercent:{type:sequelize_1.DataTypes.FLOAT,allowNull:!0},profitCurrency:{type:sequelize_1.DataTypes.STRING(20),allowNull:!0},status:{type:sequelize_1.DataTypes.ENUM("PENDING","PENDING_REPLICATION","REPLICATED","REPLICATION_FAILED","OPEN","CLOSED","PARTIALLY_FILLED","FAILED","CANCELLED"),allowNull:!1,defaultValue:"PENDING"},errorMessage:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},isLeaderTrade:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},createdAt:{type:sequelize_1.DataTypes.DATE,allowNull:!1,defaultValue:sequelize_1.DataTypes.NOW},updatedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!1,defaultValue:sequelize_1.DataTypes.NOW},closedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0}},{sequelize:e,modelName:"copyTradingTrade",tableName:"copy_trading_trades",timestamps:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"copy_trading_trades_leader_id_idx",fields:[{name:"leaderId"}]},{name:"copy_trading_trades_follower_id_idx",fields:[{name:"followerId"}]},{name:"copy_trading_trades_leader_order_id_idx",fields:[{name:"leaderOrderId"}]},{name:"copy_trading_trades_symbol_idx",fields:[{name:"symbol"}]},{name:"copy_trading_trades_status_idx",fields:[{name:"status"}]},{name:"copy_trading_trades_created_at_idx",fields:[{name:"createdAt"}]}]})}static associate(e){copyTradingTrade.belongsTo(e.copyTradingLeader,{foreignKey:"leaderId",as:"leader",onDelete:"CASCADE",onUpdate:"CASCADE"});copyTradingTrade.belongsTo(e.copyTradingFollower,{foreignKey:"followerId",as:"follower",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=copyTradingTrade;